﻿:setvar DatabaseName "RegistryQA"
:setvar MajorReleaseNumber "1"
:setvar MinorReleaseNumber "0"
:setvar PointReleaseNumber "24"
:setvar DeployVersion "20150223.1"


SET ANSI_NULLS, ANSI_PADDING, ANSI_WARNINGS, ARITHABORT, CONCAT_NULL_YIELDS_NULL, QUOTED_IDENTIFIER ON;

SET NUMERIC_ROUNDABORT OFF;


GO

:on error exit
GO
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
SET NOEXEC OFF; 
*/
:setvar __IsSqlCmdEnabled "True"
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON;
    END


GO


PRINT ' 
------------------------------------------------------------------------------------------------
Step 2 - Registry.Database.Deploy.sql

Version Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

Build $(DeployVersion)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO

USE [$(DatabaseName)]
GO

GO
PRINT N'Creating [AHOBPR]...';


GO
CREATE SCHEMA [AHOBPR]
    AUTHORIZATION [dbo];


GO
PRINT N'Creating [AHOBPR].[STD_CONCEPT]...';


GO
CREATE TABLE [AHOBPR].[STD_CONCEPT] (
    [STD_CONCEPT_ID]    INT            IDENTITY (1, 1) NOT NULL,
    [DESCRIPTION]       VARCHAR (4000) NOT NULL,
    [SHORT_DESCRIPTION] VARCHAR (255)  NULL,
    [CREATEDBY]         VARCHAR (30)   NOT NULL,
    [UPDATEDBY]         VARCHAR (30)   NOT NULL,
    [CREATED]           DATETIME2 (0)  NOT NULL,
    [UPDATED]           DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]       ROWVERSION     NOT NULL,
    CONSTRAINT [PK_STD_CONCEPT] PRIMARY KEY CLUSTERED ([STD_CONCEPT_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_TERM]...';


GO
CREATE TABLE [AHOBPR].[STD_TERM] (
    [STD_TERM_ID]        INT            IDENTITY (1, 1) NOT NULL,
    [STD_CONCEPT_ID]     INT            NULL,
    [SYSTEM_STD_TERM_ID] INT            NULL,
    [CODE]               VARCHAR (50)   NOT NULL,
    [SHORT_DESCRIPTION]  VARCHAR (100)  NOT NULL,
    [DESCRIPTION]        VARCHAR (4000) NOT NULL,
    [CREATEDBY]          VARCHAR (30)   NOT NULL,
    [UPDATEDBY]          VARCHAR (30)   NOT NULL,
    [CREATED]            DATETIME2 (0)  NOT NULL,
    [UPDATED]            DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]        ROWVERSION     NOT NULL,
    CONSTRAINT [PK_STD_CONCEPT_SYSTEM] PRIMARY KEY CLUSTERED ([STD_TERM_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_TERM].[AK_STD_TERM]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [AK_STD_TERM]
    ON [AHOBPR].[STD_TERM]([SYSTEM_STD_TERM_ID] ASC, [CODE] ASC)
    ON [PRIMARY];


GO
PRINT N'Creating [AHOBPR].[TMP_POST_REQ_XREF]...';


GO
CREATE TABLE [AHOBPR].[TMP_POST_REQ_XREF] (
    [STD_FORM_ANSWER_ID]            INT           NULL,
    [STD_FORM_QUESTION_ID]          INT           NULL,
    [STD_FORM_SUB_SECTION_ID]       INT           NULL,
    [STD_FORM_QUESTION_ID_POST_REQ] INT           NULL,
    [BRP_FORM_QUESTION_ID]          VARCHAR (100) NULL
) ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[STD_FORM]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM] (
    [STD_FORM_ID] INT           IDENTITY (1, 1) NOT NULL,
    [NAME]        VARCHAR (256) NOT NULL,
    [VERSION]     VARCHAR (50)  NOT NULL,
    [TITLE]       VARCHAR (500) NULL,
    [OMB]         VARCHAR (500) NULL,
    [BPR_FORM_ID] INT           NULL,
    [CREATEDBY]   VARCHAR (30)  NOT NULL,
    [UPDATEDBY]   VARCHAR (30)  NOT NULL,
    [CREATED]     DATETIME2 (0) NOT NULL,
    [UPDATED]     DATETIME2 (0) NOT NULL,
    [ROW_VERSION] ROWVERSION    NOT NULL,
    CONSTRAINT [PK_BPRFORMSCHEMA] PRIMARY KEY CLUSTERED ([STD_FORM_ID] ASC) ON [AHOBPR],
    CONSTRAINT [UK_BPR_FORM_ID] UNIQUE NONCLUSTERED ([BPR_FORM_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM_ANSWER] (
    [STD_FORM_ANSWER_ID]      INT            IDENTITY (1, 1) NOT NULL,
    [STD_FORM_QUESTION_ID]    INT            NOT NULL,
    [STD_FORM_SUB_SECTION_ID] INT            NOT NULL,
    [STD_FORM_SECTION_ID]     INT            NOT NULL,
    [STD_FORM_ID]             INT            NOT NULL,
    [ORDER]                   INT            NOT NULL,
    [TEXT]                    VARCHAR (4000) NULL,
    [EDITABLE]                BIT            NOT NULL,
    [HELP]                    VARCHAR (1000) NOT NULL,
    [STD_CONCEPT_ID]          INT            NULL,
    [CLINICAL_RELEVANT_FLAG]  BIT            NOT NULL,
    [BRP_FORM_ANSWER_ID]      VARCHAR (100)  NULL,
    [BRP_FORM_QUESTION_ID]    VARCHAR (100)  NULL,
    [CREATEDBY]               VARCHAR (30)   NOT NULL,
    [UPDATEDBY]               VARCHAR (30)   NOT NULL,
    [CREATED]                 DATETIME2 (0)  NOT NULL,
    [UPDATED]                 DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]             ROWVERSION     NOT NULL,
    CONSTRAINT [PK_STD_FORM_ANSWER] PRIMARY KEY CLUSTERED ([STD_FORM_ANSWER_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_FORM_ANSWER_FIELD]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM_ANSWER_FIELD] (
    [STD_FORM_ANSWER_FIELD_ID] INT           IDENTITY (1, 1) NOT NULL,
    [STD_FORM_ANSWER_ID]       INT           NOT NULL,
    [LABEL]                    VARCHAR (500) NOT NULL,
    [MIN]                      VARCHAR (500) NULL,
    [MAX]                      VARCHAR (500) NULL,
    [CREATEDBY]                VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                VARCHAR (30)  NOT NULL,
    [CREATED]                  DATETIME2 (0) NOT NULL,
    [UPDATED]                  DATETIME2 (0) NOT NULL,
    [ROW_VERSION]              ROWVERSION    NOT NULL,
    CONSTRAINT [PK_STD_FORM_ANSWER_FIELD] PRIMARY KEY CLUSTERED ([STD_FORM_ANSWER_FIELD_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_FORM_POST_REQ_XREF]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM_POST_REQ_XREF] (
    [STD_FORM_POST_REQ_XREF_ID]     INT           IDENTITY (1, 1) NOT NULL,
    [STD_FORM_ANSWER_ID]            INT           NULL,
    [STD_FORM_QUESTION_ID]          INT           NULL,
    [STD_FORM_QUESTION_ID_POST_REQ] INT           NULL,
    [CREATEDBY]                     VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                     VARCHAR (30)  NOT NULL,
    [CREATED]                       DATETIME2 (0) NOT NULL,
    [UPDATED]                       DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                   ROWVERSION    NOT NULL,
    CONSTRAINT [PK_STD_FORM_POST_REQ_XREF] PRIMARY KEY CLUSTERED ([STD_FORM_POST_REQ_XREF_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_FORM_PRE_REQ_XREF]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM_PRE_REQ_XREF] (
    [STD_FORM_PRE_REQ_XREF_ID]     INT           IDENTITY (1, 1) NOT NULL,
    [STD_FORM_QUESTION_ID]         INT           NULL,
    [STD_FORM_QUESTION_ID_PRE_REQ] INT           NULL,
    [STD_FORM_ANSWER_ID_PRE_REQ]   INT           NULL,
    [CREATEDBY]                    VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                    VARCHAR (30)  NOT NULL,
    [CREATED]                      DATETIME2 (0) NOT NULL,
    [UPDATED]                      DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                  ROWVERSION    NOT NULL,
    CONSTRAINT [PK_STD_FORM_PRE_REQ_XREF] PRIMARY KEY CLUSTERED ([STD_FORM_PRE_REQ_XREF_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SECTION]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM_SECTION] (
    [STD_FORM_SECTION_ID] INT            IDENTITY (1, 1) NOT NULL,
    [STD_FORM_ID]         INT            NOT NULL,
    [TITLE]               VARCHAR (255)  NULL,
    [INTRODUCTION]        VARCHAR (4000) NULL,
    [CONCLUSION]          VARCHAR (4000) NULL,
    [DESCRIPTION]         VARCHAR (4000) NULL,
    [NOTES]               TEXT           NULL,
    [LINE_NUMBER]         INT            NULL,
    [BRP_FORM_SECTION_ID] INT            NULL,
    [MENU_ITEM_NAME]      VARCHAR (100)  NULL,
    [CREATEDBY]           VARCHAR (30)   NOT NULL,
    [UPDATEDBY]           VARCHAR (30)   NOT NULL,
    [CREATED]             DATETIME2 (0)  NOT NULL,
    [UPDATED]             DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]         ROWVERSION     NOT NULL,
    CONSTRAINT [PK_STD_FORM_SECTION] PRIMARY KEY CLUSTERED ([STD_FORM_SECTION_ID] ASC) ON [AHOBPR]
) TEXTIMAGE_ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[STD_FORM_SUB_SECTION]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM_SUB_SECTION] (
    [STD_FORM_SUB_SECTION_ID] INT            IDENTITY (1, 1) NOT NULL,
    [STD_FORM_SECTION_ID]     INT            NOT NULL,
    [STD_FORM_ID]             INT            NOT NULL,
    [TITLE]                   VARCHAR (255)  NULL,
    [INTRODUCTION]            VARCHAR (4000) NULL,
    [CONCLUSION]              VARCHAR (4000) NULL,
    [BRP_FORM_SUB_SECTION_ID] INT            NULL,
    [MENU_ITEM_NAME]          VARCHAR (100)  NULL,
    [CREATEDBY]               VARCHAR (30)   NOT NULL,
    [UPDATEDBY]               VARCHAR (30)   NOT NULL,
    [CREATED]                 DATETIME2 (0)  NOT NULL,
    [UPDATED]                 DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]             ROWVERSION     NOT NULL,
    CONSTRAINT [PK_STD_FORM_SUB_SECTION] PRIMARY KEY CLUSTERED ([STD_FORM_SUB_SECTION_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_PROCESS_METRICS_TYPE]...';


GO
CREATE TABLE [AHOBPR].[STD_PROCESS_METRICS_TYPE] (
    [STD_PROCESS_METRICS_TYPE_ID] INT           IDENTITY (1, 1) NOT NULL,
    [PROCESS_METRICS]             VARCHAR (256) NOT NULL,
    [CREATEDBY]                   VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                   VARCHAR (30)  NOT NULL,
    [CREATED]                     DATETIME2 (0) NOT NULL,
    [UPDATED]                     DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                 ROWVERSION    NOT NULL,
    CONSTRAINT [STD_PROCESS_METRICS_TYPE_PK] PRIMARY KEY CLUSTERED ([STD_PROCESS_METRICS_TYPE_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRANT_STATUS]...';


GO
CREATE TABLE [AHOBPR].[STD_REGISTRANT_STATUS] (
    [STD_REGISTRANT_STATUS_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_STATUS]        VARCHAR (100) NOT NULL,
    [ORDINAL_VALUE]            TINYINT       NOT NULL,
    [CREATEDBY]                VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                VARCHAR (30)  NOT NULL,
    [CREATED]                  DATETIME2 (0) NOT NULL,
    [UPDATED]                  DATETIME2 (0) NOT NULL,
    [ROW_VERSION]              ROWVERSION    NOT NULL,
    CONSTRAINT [STD_REGISTRANT_STATUS_PK] PRIMARY KEY CLUSTERED ([STD_REGISTRANT_STATUS_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRANT_STATUS].[AK_STD_REGISTRANT_STATUS]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [AK_STD_REGISTRANT_STATUS]
    ON [AHOBPR].[STD_REGISTRANT_STATUS]([REGISTRANT_STATUS] ASC);


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_STATUS]...';


GO
CREATE TABLE [AHOBPR].[STD_SERVICE_STATUS] (
    [STD_SERVICE_STATUS_ID] INT           IDENTITY (1, 1) NOT NULL,
    [SERVICE_STATUS]        VARCHAR (100) NOT NULL,
    [CREATEDBY]             VARCHAR (30)  NOT NULL,
    [UPDATEDBY]             VARCHAR (30)  NOT NULL,
    [CREATED]               DATETIME2 (0) NOT NULL,
    [UPDATED]               DATETIME2 (0) NOT NULL,
    [ROW_VERSION]           ROWVERSION    NOT NULL,
    CONSTRAINT [STD_SERVICE_STATUS_PK] PRIMARY KEY CLUSTERED ([STD_SERVICE_STATUS_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_SERVICE_STATUS].[AK_STD_SERVICE_STATUS]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [AK_STD_SERVICE_STATUS]
    ON [AHOBPR].[STD_SERVICE_STATUS]([SERVICE_STATUS] ASC);


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG_TYPE]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_REGISTRY_FLAG_TYPE] (
    [STD_REGISTRY_FLAG_TYPE_ID]      INT            IDENTITY (1, 1) NOT NULL,
    [REGISTRY_FLAG_TYPE]             VARCHAR (100)  NOT NULL,
    [REGISTRY_FLAG_TYPE_DESCRIPTION] VARCHAR (1000) NULL,
    [CREATEDBY]                      VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                      VARCHAR (30)   NOT NULL,
    [CREATED]                        DATETIME2 (0)  NOT NULL,
    [UPDATED]                        DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]                    ROWVERSION     NOT NULL,
    [ACTIVE_FLAG]                    BIT            NOT NULL,
    CONSTRAINT [PK_STD_REGISTRY_FLAG_TYPE] PRIMARY KEY CLUSTERED ([STD_REGISTRY_FLAG_TYPE_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_DEPLOYMENT_LOCATION]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_DEPLOYMENT_LOCATION] (
    [STD_DEPLOYMENT_LOCATION_ID] INT           IDENTITY (1, 1) NOT NULL,
    [BASE]                       VARCHAR (100) NULL,
    [COUNTRY]                    VARCHAR (200) NULL,
    [OTHER_NAMES]                VARCHAR (200) NULL,
    [NAMES]                      VARCHAR (100) NULL,
    [PROVINCE]                   VARCHAR (200) NULL,
    [USER_ADDED_FLAG]            BIT           NOT NULL,
    [CREATEDBY]                  VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                  VARCHAR (30)  NOT NULL,
    [CREATED]                    DATETIME2 (0) NOT NULL,
    [UPDATED]                    DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                ROWVERSION    NOT NULL,
    CONSTRAINT [STD_DEPLOYMENT_LOCATION_PK] PRIMARY KEY CLUSTERED ([STD_DEPLOYMENT_LOCATION_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_BRANCH_OF_SERVICE]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_BRANCH_OF_SERVICE] (
    [STD_BRANCH_OF_SERVICE_ID] INT           IDENTITY (1, 1) NOT NULL,
    [BRANCH_OF_SERVICE]        VARCHAR (100) NOT NULL,
    [CREATEDBY]                VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                VARCHAR (30)  NOT NULL,
    [CREATED]                  DATETIME2 (0) NOT NULL,
    [UPDATED]                  DATETIME2 (0) NOT NULL,
    [ROW_VERSION]              ROWVERSION    NOT NULL,
    CONSTRAINT [STD_BRANCH_OF_SERVICE_PK] PRIMARY KEY CLUSTERED ([STD_BRANCH_OF_SERVICE_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG]...';


GO
CREATE TABLE [AHOBPR].[STD_REGISTRY_FLAG] (
    [STD_REGISTRY_FLAG_ID]      INT            IDENTITY (1, 1) NOT NULL,
    [REGISTRY_FLAG_NAME]        VARCHAR (100)  NOT NULL,
    [REGISTRY_FLAG_DESCRIPTION] VARCHAR (1000) NULL,
    [STD_REGISTRY_FLAG_TYPE_ID] INT            NOT NULL,
    [ACTIVE_FLAG]               BIT            NOT NULL,
    [PREDEFINED]                BIT            NOT NULL,
    [CREATEDBY]                 VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                 VARCHAR (30)   NOT NULL,
    [CREATED]                   DATETIME2 (0)  NOT NULL,
    [UPDATED]                   DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]               ROWVERSION     NOT NULL,
    CONSTRAINT [PK_STD_REGISTRY_FLAG] PRIMARY KEY CLUSTERED ([STD_REGISTRY_FLAG_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[AK_StdRegistryFlag_Name]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [AK_StdRegistryFlag_Name]
    ON [AHOBPR].[STD_REGISTRY_FLAG]([REGISTRY_FLAG_NAME] ASC);


GO
PRINT N'Creating [AHOBPR].[STD_REGISTRY_FLAG].[IX_StdRegistryFlag_StdRegistryFlagType]...';


GO
CREATE NONCLUSTERED INDEX [IX_StdRegistryFlag_StdRegistryFlagType]
    ON [AHOBPR].[STD_REGISTRY_FLAG]([STD_REGISTRY_FLAG_TYPE_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[STD_FORM_QUESTION]...';


GO
CREATE TABLE [AHOBPR].[STD_FORM_QUESTION] (
    [STD_FORM_QUESTION_ID]    INT            IDENTITY (1, 1) NOT NULL,
    [STD_FORM_SUB_SECTION_ID] INT            NOT NULL,
    [STD_FORM_SECTION_ID]     INT            NOT NULL,
    [STD_FORM_ID]             INT            NOT NULL,
    [TEXT]                    VARCHAR (4000) NOT NULL,
    [TYPE]                    VARCHAR (100)  NOT NULL,
    [MIN]                     VARCHAR (256)  NOT NULL,
    [MAX]                     VARCHAR (256)  NOT NULL,
    [MAX_CHOICES]             INT            NULL,
    [STD_CONCEPT_ID]          INT            NULL,
    [PARENT_ID]               INT            NULL,
    [FORM_QUESTION_UNIQUE_ID] VARCHAR (100)  NULL,
    [BRP_FORM_QUESTION_ID]    VARCHAR (100)  NULL,
    [BRP_PARENT_QUESTION_ID]  VARCHAR (100)  NULL,
    [MAX_LENGTH]              INT            NULL,
    [MIN_LENGTH]              INT            NULL,
    [POST_REQ_TRIGGER_ONCE]   VARCHAR (100)  NULL,
    [PRE_REQ_OPERATOR]        VARCHAR (100)  NULL,
    [SOURCE_ID]               VARCHAR (100)  NULL,
    [CREATEDBY]               VARCHAR (30)   NOT NULL,
    [UPDATEDBY]               VARCHAR (30)   NOT NULL,
    [CREATED]                 DATETIME2 (0)  NOT NULL,
    [UPDATED]                 DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]             ROWVERSION     NOT NULL,
    [SHORT_TEXT]              VARCHAR (4000) NULL,
    CONSTRAINT [PK_STD_FORM_QUESTION] PRIMARY KEY CLUSTERED ([STD_FORM_QUESTION_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[ERROR_LOG]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[ERROR_LOG] (
    [ERROR_LOG_ID]   INT           IDENTITY (1, 1) NOT NULL,
    [COMPONENT_TYPE] VARCHAR (100) NOT NULL,
    [ERROR_TYPE]     VARCHAR (100) NOT NULL,
    [ERROR_SOURCE]   VARCHAR (200) NOT NULL,
    [ERROR_MESSAGE]  VARCHAR (MAX) NOT NULL,
    [CREATEDBY]      VARCHAR (30)  NOT NULL,
    [UPDATEDBY]      VARCHAR (30)  NOT NULL,
    [CREATED]        DATETIME2 (0) NOT NULL,
    [UPDATED]        DATETIME2 (0) NOT NULL,
    [ROW_VERSION]    ROWVERSION    NOT NULL,
    CONSTRAINT [ERROR_LOG_PK] PRIMARY KEY CLUSTERED ([ERROR_LOG_ID] ASC) ON [AHOBPR]
) ON [AHOBPR] TEXTIMAGE_ON [AHOBPR];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_HEALTH_FACTOR] (
    [STD_HEALTH_FACTOR_ID]          SMALLINT       IDENTITY (1, 1) NOT NULL,
    [NAME]                          VARCHAR (50)   NOT NULL,
    [DESCRIPTION]                   VARCHAR (4000) NULL,
    [STD_HEALTH_FACTOR_CATEGORY_ID] TINYINT        NULL,
    [ACTIVE_FLAG]                   BIT            NOT NULL,
    [CREATEDBY]                     VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                     VARCHAR (30)   NOT NULL,
    [CREATED]                       DATETIME2 (0)  NOT NULL,
    [UPDATED]                       DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]                   ROWVERSION     NOT NULL,
    [SORT_ORDER]                    INT            NULL,
    CONSTRAINT [PK_STD_HEALTH_FACTOR] PRIMARY KEY CLUSTERED ([STD_HEALTH_FACTOR_ID] ASC)
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR].[AK_StdHealthFactor_Name]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [AK_StdHealthFactor_Name]
    ON [AHOBPR].[STD_HEALTH_FACTOR]([NAME] ASC);


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] (
    [STD_HEALTH_FACTOR_CATEGORY_ID] TINYINT        IDENTITY (1, 1) NOT NULL,
    [NAME]                          VARCHAR (50)   NOT NULL,
    [DESCRIPTION]                   VARCHAR (4000) NULL,
    [ACTIVE_FLAG]                   BIT            NOT NULL,
    [CREATEDBY]                     VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                     VARCHAR (30)   NOT NULL,
    [CREATED]                       DATETIME2 (0)  NOT NULL,
    [UPDATED]                       DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]                   ROWVERSION     NOT NULL,
    [TOOLTIP]                       VARCHAR (200)  NULL,
    CONSTRAINT [PK_STD_HEALTH_FACTOR_CATEGORY] PRIMARY KEY CLUSTERED ([STD_HEALTH_FACTOR_CATEGORY_ID] ASC)
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY].[AK_STD_HEALTH_FACTOR_CATEGORY]...';


GO
CREATE UNIQUE NONCLUSTERED INDEX [AK_STD_HEALTH_FACTOR_CATEGORY]
    ON [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY]([NAME] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_HEALTH_FACTOR]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR] (
    [REGISTRANT_HEALTH_FACTOR_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_EVALUATION_ID]    INT           NULL,
    [STD_HEALTH_FACTOR_ID]        SMALLINT      NOT NULL,
    [ACTIVE_FLAG]                 BIT           NOT NULL,
    [CREATEDBY]                   VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                   VARCHAR (30)  NOT NULL,
    [CREATED]                     DATETIME2 (0) NOT NULL,
    [UPDATED]                     DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                 ROWVERSION    NOT NULL,
    CONSTRAINT [PK_REGISTRANT_HEALTH_FACTOR] PRIMARY KEY CLUSTERED ([REGISTRANT_HEALTH_FACTOR_ID] ASC)
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] (
    [REGISTRANT_DEPLOYMENT_ID]  INT            IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]             INT            NOT NULL,
    [STD_BRANCH_OF_SERVICE_ID]  INT            NULL,
    [DUTY_PROJECT_CODE]         VARCHAR (100)  NULL,
    [OCCUPATION_SPECIALTY_CODE] VARCHAR (50)   NULL,
    [MILITARY_RANK]             VARCHAR (50)   NULL,
    [DEPLOYMENT_UIC]            CHAR (6)       NULL,
    [DEPLOYMENT_COUNTRY]        VARCHAR (100)  NULL,
    [DEPLOYMENT_BASE]           VARCHAR (255)  NULL,
    [DEPLOYMENT_START_DATE]     DATETIME2 (0)  NULL,
    [DEPLOYMENT_END_DATE]       DATETIME2 (0)  NULL,
    [IS_GULF_WAR_VETERAN_FLAG]  BIT            NULL,
    [IS_ELIGIBLE_FLAG]          BIT            NULL,
    [USER_ENTERED_FLAG]         BIT            NULL,
    [USER_VERIFIED_FLAG]        BIT            NULL,
    [LAST_UPDATED_DATE]         DATETIME2 (0)  NULL,
    [PREVIOUS_VALUES]           VARCHAR (4000) NULL,
    [PREVIOUS_UPDATED_DATE]     DATETIME2 (0)  NULL,
    [CREATEDBY]                 VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                 VARCHAR (30)   NOT NULL,
    [CREATED]                   DATETIME2 (0)  NOT NULL,
    [UPDATED]                   DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]               ROWVERSION     NOT NULL,
    CONSTRAINT [PK_REGISTRANT_DEPLOYMENT] PRIMARY KEY CLUSTERED ([REGISTRANT_DEPLOYMENT_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT].[IX_RegistrantDeploymentHistory_RegistryId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantDeploymentHistory_RegistryId]
    ON [AHOBPR].[REGISTRANT_DEPLOYMENT]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT].[IX_RegistrantDeploymentHistory_StdBranchOfServiceId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantDeploymentHistory_StdBranchOfServiceId]
    ON [AHOBPR].[REGISTRANT_DEPLOYMENT]([STD_BRANCH_OF_SERVICE_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_CONTACT_INFO]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_CONTACT_INFO] (
    [REGISTRANT_ID]         INT           NOT NULL,
    [FIRST_NAME_CONFIRMED]  VARCHAR (50)  NULL,
    [MIDDLE_NAME_CONFIRMED] VARCHAR (50)  NULL,
    [LAST_NAME_CONFIRMED]   VARCHAR (50)  NULL,
    [LAST_UPDATED_DATE]     DATETIME2 (0) NULL,
    [PREVIOUS_VALUES]       VARCHAR (MAX) NULL,
    [PREVIOUS_UPDATED_DATE] DATETIME2 (0) NULL,
    [CREATEDBY]             VARCHAR (30)  NOT NULL,
    [UPDATEDBY]             VARCHAR (30)  NOT NULL,
    [CREATED]               DATETIME2 (0) NOT NULL,
    [UPDATED]               DATETIME2 (0) NOT NULL,
    [ROW_VERSION]           ROWVERSION    NOT NULL,
    CONSTRAINT [PK_REGISTRANT_CONTACT_INFO_ID] PRIMARY KEY CLUSTERED ([REGISTRANT_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_CONTACT_INFO].[IX_RegistrantContactInfo_RegistrantInfoId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantContactInfo_RegistrantInfoId]
    ON [AHOBPR].[REGISTRANT_CONTACT_INFO]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EVALUATION]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_EVALUATION] (
    [REGISTRANT_EVALUATION_ID] INT           IDENTITY (10, 1) NOT NULL,
    [EVALUATION_DATE_TIME]     DATETIME2 (0) NULL,
    [STD_INSTITUTION_ID]       INT           NULL,
    [CDW_AmbEncSID]            BIGINT        NULL,
    [VISTA_EncounterID]        VARCHAR (50)  NULL,
    [VISTA_Sta3n]              SMALLINT      NULL,
    [VISTA_PatientIEN]         VARCHAR (50)  NULL,
    [VISTA_Sta6a]              VARCHAR (50)  NULL,
    [VISTA_AppointmentTypeIEN] VARCHAR (50)  NULL,
    [VISTA_EligibilityIEN]     VARCHAR (20)  NULL,
    [REGISTRANT_ID]            INT           NOT NULL,
    [CREATEDBY]                VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                VARCHAR (30)  NOT NULL,
    [CREATED]                  DATETIME2 (0) NOT NULL,
    [UPDATED]                  DATETIME2 (0) NOT NULL,
    [ROW_VERSION]              ROWVERSION    NOT NULL,
    CONSTRAINT [PK_REGISTRANT_EVALUATION] PRIMARY KEY CLUSTERED ([REGISTRANT_EVALUATION_ID] ASC)
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REPORT_SEARCH_CRITERIA]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REPORT_SEARCH_CRITERIA] (
    [REPORT_SEARCH_CRITERIA_ID]   INT            IDENTITY (1, 1) NOT NULL,
    [REPORT_NAME]                 VARCHAR (100)  NOT NULL,
    [SEARCH_CRITERIA_NAME]        VARCHAR (256)  NOT NULL,
    [SEARCH_CRITERIA]             VARCHAR (4000) NOT NULL,
    [SEARCH_CRITERIA_DESCRIPTION] VARCHAR (4000) NOT NULL,
    [CREATEDBY]                   VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                   VARCHAR (30)   NOT NULL,
    [CREATED]                     DATETIME2 (0)  NOT NULL,
    [UPDATED]                     DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]                 ROWVERSION     NOT NULL,
    CONSTRAINT [REPORT_SEARCH_CRITERIA_PK] PRIMARY KEY CLUSTERED ([REPORT_SEARCH_CRITERIA_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_SERVICE_EPISODE]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] (
    [REGISTRANT_SERVICE_EPISODE_ID]      INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]                      INT           NOT NULL,
    [STD_BRANCH_OF_SERVICE_ID]           INT           NULL,
    [SERVICE_EPISODE_START_DATE]         DATE          NULL,
    [SERVICE_EPISODE_END_DATE]           DATE          NULL,
    [SERVICE_EPISODE_TERMINATION_REASON] VARCHAR (500) NULL,
    [CREATEDBY]                          VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                          VARCHAR (30)  NOT NULL,
    [CREATED]                            DATETIME2 (0) NOT NULL,
    [UPDATED]                            DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                        ROWVERSION    NOT NULL,
    CONSTRAINT [PK_REGISTRANT_SERVICE_EPISODE] PRIMARY KEY CLUSTERED ([REGISTRANT_SERVICE_EPISODE_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_REGISTRY_FLAG]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG] (
    [REGISTRANT_REGISTRY_FLAG_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]               INT           NOT NULL,
    [STD_REGISTRY_FLAG_ID]        INT           NOT NULL,
    [CREATEDBY]                   VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                   VARCHAR (30)  NOT NULL,
    [CREATED]                     DATETIME2 (0) NOT NULL,
    [UPDATED]                     DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                 ROWVERSION    NOT NULL,
    CONSTRAINT [PK_REGISTRANT_REGISTRY_FLAG] PRIMARY KEY CLUSTERED ([REGISTRANT_REGISTRY_FLAG_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_REGISTRY_FLAG].[IX_RegistrantRegistryFlag_RegistrantId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantRegistryFlag_RegistrantId]
    ON [AHOBPR].[REGISTRANT_REGISTRY_FLAG]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_REGISTRY_FLAG].[IX_RegistrantRegistryFlag_StdRegistryFlagId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantRegistryFlag_StdRegistryFlagId]
    ON [AHOBPR].[REGISTRANT_REGISTRY_FLAG]([STD_REGISTRY_FLAG_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_RECORD_INFO]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_RECORD_INFO] (
    [REGISTRANT_ID]              INT           NOT NULL,
    [EULA_ACCEPTED_DATE]         DATETIME2 (0) NULL,
    [EDIPI_VERIFIED_DATE]        DATETIME2 (0) NULL,
    [EDIPI_MISMATCHED_FLAG]      BIT           NULL,
    [CONTACT_INFO_VERIFIED_DATE] DATETIME2 (0) NULL,
    [CREATEDBY]                  VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                  VARCHAR (30)  NOT NULL,
    [CREATED]                    DATETIME2 (0) NOT NULL,
    [UPDATED]                    DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                ROWVERSION    NOT NULL,
    CONSTRAINT [REGISTRANT_INFO_ID_PK] PRIMARY KEY CLUSTERED ([REGISTRANT_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_RECORD_INFO].[IX_RegistrantInfo_RegistrantId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantInfo_RegistrantId]
    ON [AHOBPR].[REGISTRANT_RECORD_INFO]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_PHONE] (
    [REGISTRANT_PHONE_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]       INT           NOT NULL,
    [TYPE]                VARCHAR (100) NULL,
    [PHONE_NUMBER]        VARCHAR (50)  NULL,
    [CREATEDBY]           VARCHAR (30)  NOT NULL,
    [UPDATEDBY]           VARCHAR (30)  NOT NULL,
    [CREATED]             DATETIME2 (0) NOT NULL,
    [UPDATED]             DATETIME2 (0) NOT NULL,
    [ROW_VERSION]         ROWVERSION    NOT NULL,
    CONSTRAINT [REGISTRANT_PHONE_ID_PK] PRIMARY KEY CLUSTERED ([REGISTRANT_PHONE_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE].[IX_RegistrantPhone_RegistrantContactInfoId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantPhone_RegistrantContactInfoId]
    ON [AHOBPR].[REGISTRANT_PHONE]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_EMAIL] (
    [REGISTRANT_EMAIL_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]       INT           NOT NULL,
    [TYPE]                VARCHAR (100) NULL,
    [EMAIL]               VARCHAR (256) NULL,
    [CREATEDBY]           VARCHAR (30)  NOT NULL,
    [UPDATEDBY]           VARCHAR (30)  NOT NULL,
    [CREATED]             DATETIME2 (0) NOT NULL,
    [UPDATED]             DATETIME2 (0) NOT NULL,
    [ROW_VERSION]         ROWVERSION    NOT NULL,
    CONSTRAINT [REGISTRANT_EMAIL_ID_PK] PRIMARY KEY CLUSTERED ([REGISTRANT_EMAIL_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL].[IX_RegistrantEmail_RegistrantContactInfoId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantEmail_RegistrantContactInfoId]
    ON [AHOBPR].[REGISTRANT_EMAIL]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TABLE [AHOBPR].[REGISTRANT_ADDRESS] (
    [REGISTRANT_ADDRESS_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]         INT           NOT NULL,
    [TYPE]                  VARCHAR (100) NULL,
    [STREET1]               VARCHAR (256) NULL,
    [STREET2]               VARCHAR (256) NULL,
    [CITY]                  VARCHAR (100) NULL,
    [STATE]                 VARCHAR (100) NULL,
    [ZIP]                   VARCHAR (15)  NULL,
    [COUNTRY]               VARCHAR (100) NULL,
    [CREATEDBY]             VARCHAR (30)  NOT NULL,
    [UPDATEDBY]             VARCHAR (30)  NOT NULL,
    [CREATED]               DATETIME2 (0) NOT NULL,
    [UPDATED]               DATETIME2 (0) NOT NULL,
    [ROW_VERSION]           ROWVERSION    NOT NULL,
    CONSTRAINT [REGISTRANT_ADDRESS_ID_PK] PRIMARY KEY CLUSTERED ([REGISTRANT_ADDRESS_ID] ASC) ON [AHOBPR]
);


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS].[IX_RegistrantAddress_RegistrantContactInfoId]...';


GO
CREATE NONCLUSTERED INDEX [IX_RegistrantAddress_RegistrantContactInfoId]
    ON [AHOBPR].[REGISTRANT_ADDRESS]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT] (
    [REGISTRANT_ID]                          INT           IDENTITY (1, 1) NOT NULL,
    [USER_ID]                                VARCHAR (100) NULL,
    [EDIPI]                                  VARCHAR (50)  NOT NULL,
    [ICN]                                    VARCHAR (50)  NULL,
    [SSN]                                    VARCHAR (20)  NOT NULL,
    [FIRST_NAME]                             VARCHAR (50)  NULL,
    [MIDDLE_NAME]                            VARCHAR (50)  NULL,
    [LAST_NAME]                              VARCHAR (50)  NULL,
    [BIRTH_DATE]                             DATE          NULL,
    [GENDER]                                 VARCHAR (50)  NULL,
    [STD_RACE_ID]                            INT           NULL,
    [STD_ETHNICITY_ID]                       INT           NULL,
    [EMAIL]                                  VARCHAR (256) NULL,
    [STD_SERVICE_STATUS_ID]                  INT           NULL,
    [STD_BRANCH_OF_SERVICE_ID_CURRENT]       INT           NULL,
    [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED] INT           NULL,
    [UIC_CURRENT]                            CHAR (6)      NULL,
    [UIC_WHEN_ENROLLED]                      CHAR (6)      NULL,
    [STD_REGISTRANT_STATUS_ID]               INT           NULL,
    [REGISTRANT_STATUS_LAST_UPDATED_DATE]    DATETIME2 (0) NULL,
    [STD_INSTITUTION_ID]                     INT           NULL,
    [MARITAL_STATUS_ID]                      INT           NULL,
    [EDUCATION_LEVEL_ID]                     VARCHAR (50)  NULL,
    [MILITARY_SEPERATION_TYPE_CURRENT]       VARCHAR (50)  NULL,
    [MILITARY_SEPERATION_DATE_CURRENT]       DATE          NULL,
    [MILITARY_SEPERATION_TYPE_WHEN_ENROLLED] VARCHAR (50)  NULL,
    [MILITARY_SEPERATION_DATE_WHEN_ENROLLED] DATE          NULL,
    [HEALTH_CONCERNS_RESPONSE]               VARCHAR (50)  NULL,
    [REQUEST_SEEN_RESPONSE]                  VARCHAR (50)  NULL,
    [DECEASED_FLAG]                          BIT           NOT NULL,
    [DEATH_DATE]                             DATE          NULL,
    [CREATEDBY]                              VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                              VARCHAR (30)  NOT NULL,
    [CREATED]                                DATETIME2 (0) NOT NULL,
    [UPDATED]                                DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                            ROWVERSION    NOT NULL,
    CONSTRAINT [REGISTRANT_ID_PK] PRIMARY KEY CLUSTERED ([REGISTRANT_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[IX_REGISTRANT_StdRegistrantStatusId]...';


GO
CREATE NONCLUSTERED INDEX [IX_REGISTRANT_StdRegistrantStatusId]
    ON [AHOBPR].[REGISTRANT]([STD_REGISTRANT_STATUS_ID] ASC)
    ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[REGISTRANT].[IX_REGISTRANT_Updated]...';


GO
CREATE NONCLUSTERED INDEX [IX_REGISTRANT_Updated]
    ON [AHOBPR].[REGISTRANT]([UPDATED] ASC)
    ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[PROCESS_METRICS]...';


GO
CREATE TABLE [AHOBPR].[PROCESS_METRICS] (
    [PROCESS_METRICS_ID]          INT            IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]               INT            NOT NULL,
    [STD_PROCESS_METRICS_TYPE_ID] INT            NOT NULL,
    [PROCESS_METRICS_VALUE]       VARCHAR (1000) NOT NULL,
    [CREATEDBY]                   VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                   VARCHAR (30)   NOT NULL,
    [CREATED]                     DATETIME2 (0)  NOT NULL,
    [UPDATED]                     DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]                 ROWVERSION     NOT NULL,
    CONSTRAINT [PROCESS_METRICS_ID_PK] PRIMARY KEY CLUSTERED ([PROCESS_METRICS_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_STATUS]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_STATUS] (
    [FORM_RESPONSE_STATUS_ID]      INT           IDENTITY (1, 1) NOT NULL,
    [FORM_RESPONSE_ID]             INT           NOT NULL,
    [LAST_SECTION_ID]              INT           NULL,
    [LAST_SUB_SECTION_ID]          INT           NULL,
    [QUESTIONNAIRE_STARTED_DATE]   DATETIME2 (0) NOT NULL,
    [QUESTIONNAIRE_COMPLETED_DATE] DATETIME2 (0) NULL,
    [CREATEDBY]                    VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                    VARCHAR (30)  NOT NULL,
    [CREATED]                      DATETIME2 (0) NOT NULL,
    [UPDATED]                      DATETIME2 (0) NOT NULL,
    [ROW_VERSION]                  ROWVERSION    NOT NULL,
    CONSTRAINT [PK_FORM_RESPONSE_STATUS] PRIMARY KEY CLUSTERED ([FORM_RESPONSE_STATUS_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] (
    [FORM_RESPONSE_QUESTION_ID] INT           IDENTITY (1, 1) NOT NULL,
    [FORM_RESPONSE_ID]          INT           NOT NULL,
    [STD_FORM_QUESTION_ID]      INT           NOT NULL,
    [REGISTRANT_DEPLOYMENT_ID]  INT           NULL,
    [STARTED_DATE]              DATETIME2 (0) NOT NULL,
    [COMPLETED_DATE]            DATETIME2 (0) NULL,
    [CREATEDBY]                 VARCHAR (30)  NOT NULL,
    [UPDATEDBY]                 VARCHAR (30)  NOT NULL,
    [CREATED]                   DATETIME2 (0) NOT NULL,
    [UPDATED]                   DATETIME2 (0) NOT NULL,
    [ROW_VERSION]               ROWVERSION    NOT NULL,
    CONSTRAINT [PK_FORM_RESPONSE_QUESTION] PRIMARY KEY CLUSTERED ([FORM_RESPONSE_QUESTION_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_ANSWER] (
    [FORM_RESPONSE_ANSWER_ID]   INT            IDENTITY (1, 1) NOT NULL,
    [FORM_RESPONSE_QUESTION_ID] INT            NOT NULL,
    [STD_FORM_ANSWER_ID]        INT            NOT NULL,
    [ANSWER_VALUE]              VARCHAR (4000) NULL,
    [CREATEDBY]                 VARCHAR (30)   NOT NULL,
    [UPDATEDBY]                 VARCHAR (30)   NOT NULL,
    [CREATED]                   DATETIME2 (0)  NOT NULL,
    [UPDATED]                   DATETIME2 (0)  NOT NULL,
    [ROW_VERSION]               ROWVERSION     NOT NULL,
    CONSTRAINT [PK_FORM_RESPONSE_ANSWER] PRIMARY KEY CLUSTERED ([FORM_RESPONSE_ANSWER_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[IX_FormResponseAnswer_FormResponseDetailId]...';


GO
CREATE NONCLUSTERED INDEX [IX_FormResponseAnswer_FormResponseDetailId]
    ON [AHOBPR].[FORM_RESPONSE_ANSWER]([FORM_RESPONSE_QUESTION_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[IX_FormResponseAnswer_StdFormAnswerId]...';


GO
CREATE NONCLUSTERED INDEX [IX_FormResponseAnswer_StdFormAnswerId]
    ON [AHOBPR].[FORM_RESPONSE_ANSWER]([STD_FORM_ANSWER_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE] (
    [FORM_RESPONSE_ID] INT           IDENTITY (1, 1) NOT NULL,
    [REGISTRANT_ID]    INT           NOT NULL,
    [STD_FORM_ID]      INT           NOT NULL,
    [CREATEDBY]        VARCHAR (30)  NOT NULL,
    [UPDATEDBY]        VARCHAR (30)  NOT NULL,
    [CREATED]          DATETIME2 (0) NOT NULL,
    [UPDATED]          DATETIME2 (0) NOT NULL,
    [ROW_VERSION]      ROWVERSION    NOT NULL,
    CONSTRAINT [PK_FORM_RESPONSE] PRIMARY KEY CLUSTERED ([FORM_RESPONSE_ID] ASC) ON [AHOBPR]
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE].[IX_FormResponse_RegistrantId]...';


GO
CREATE NONCLUSTERED INDEX [IX_FormResponse_RegistrantId]
    ON [AHOBPR].[FORM_RESPONSE]([REGISTRANT_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE].[IX_FormResponse_StdFormId]...';


GO
CREATE NONCLUSTERED INDEX [IX_FormResponse_StdFormId]
    ON [AHOBPR].[FORM_RESPONSE]([STD_FORM_ID] ASC);


GO
PRINT N'Creating [AHOBPR].[REPORT_SEARCH_CRITERIA_H]...';


GO
CREATE TABLE [AHOBPR].[REPORT_SEARCH_CRITERIA_H] (
    [Audit_REPORT_SEARCH_CRITERIA_H_ID] INT            IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                        DATETIME       NOT NULL,
    [Audit_Type]                        VARCHAR (20)   NOT NULL,
    [Audit_ApplicationUser]             VARCHAR (128)  NULL,
    [Audit_SQLUser]                     VARCHAR (100)  NULL,
    [REPORT_SEARCH_CRITERIA_ID]         INT            NULL,
    [REPORT_NAME]                       VARCHAR (100)  NULL,
    [SEARCH_CRITERIA_NAME]              VARCHAR (256)  NULL,
    [SEARCH_CRITERIA]                   VARCHAR (4000) NULL,
    [SEARCH_CRITERIA_DESCRIPTION]       VARCHAR (4000) NULL,
    [CREATEDBY]                         VARCHAR (30)   NULL,
    [UPDATEDBY]                         VARCHAR (30)   NULL,
    [CREATED]                           DATETIME2 (7)  NULL,
    [UPDATED]                           DATETIME2 (7)  NULL,
    CONSTRAINT [REPORT_SEARCH_CRITERIA_H_PK] PRIMARY KEY CLUSTERED ([Audit_REPORT_SEARCH_CRITERIA_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_SERVICE_EPISODE_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE_H] (
    [Audit_REGISTRANT_SERVICE_EPISODE_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                            DATETIME      NOT NULL,
    [Audit_Type]                            VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]                 VARCHAR (128) NULL,
    [Audit_SQLUser]                         VARCHAR (100) NULL,
    [REGISTRANT_SERVICE_EPISODE_ID]         INT           NULL,
    [REGISTRANT_ID]                         INT           NULL,
    [STD_BRANCH_OF_SERVICE_ID]              INT           NULL,
    [SERVICE_EPISODE_START_DATE]            DATE          NULL,
    [SERVICE_EPISODE_END_DATE]              DATE          NULL,
    [SERVICE_EPISODE_TERMINATION_REASON]    VARCHAR (500) NULL,
    [CREATEDBY]                             VARCHAR (30)  NULL,
    [UPDATEDBY]                             VARCHAR (30)  NULL,
    [CREATED]                               DATETIME2 (7) NULL,
    [UPDATED]                               DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_SERVICE_EPISODE_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_SERVICE_EPISODE_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_REGISTRY_FLAG_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG_H] (
    [Audit_REGISTRANT_REGISTRY_FLAG_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                          DATETIME      NOT NULL,
    [Audit_Type]                          VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]               VARCHAR (128) NULL,
    [Audit_SQLUser]                       VARCHAR (100) NULL,
    [REGISTRANT_REGISTRY_FLAG_ID]         INT           NULL,
    [REGISTRANT_ID]                       INT           NULL,
    [STD_REGISTRY_FLAG_ID]                INT           NULL,
    [CREATEDBY]                           VARCHAR (30)  NULL,
    [UPDATEDBY]                           VARCHAR (30)  NULL,
    [CREATED]                             DATETIME2 (7) NULL,
    [UPDATED]                             DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_REGISTRY_FLAG_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_REGISTRY_FLAG_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_RECORD_INFO_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_RECORD_INFO_H] (
    [Audit_REGISTRANT_RECORD_INFO_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                        DATETIME      NOT NULL,
    [Audit_Type]                        VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]             VARCHAR (128) NULL,
    [Audit_SQLUser]                     VARCHAR (100) NULL,
    [REGISTRANT_ID]                     INT           NULL,
    [EULA_ACCEPTED_DATE]                DATETIME2 (7) NULL,
    [EDIPI_VERIFIED_DATE]               DATETIME2 (7) NULL,
    [EDIPI_MISMATCHED_FLAG]             BIT           NULL,
    [CONTACT_INFO_VERIFIED_DATE]        DATETIME2 (7) NULL,
    [CREATEDBY]                         VARCHAR (30)  NULL,
    [UPDATEDBY]                         VARCHAR (30)  NULL,
    [CREATED]                           DATETIME2 (7) NULL,
    [UPDATED]                           DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_RECORD_INFO_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_RECORD_INFO_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_PHONE_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_PHONE_H] (
    [Audit_REGISTRANT_PHONE_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                  DATETIME      NOT NULL,
    [Audit_Type]                  VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]       VARCHAR (128) NULL,
    [Audit_SQLUser]               VARCHAR (100) NULL,
    [REGISTRANT_PHONE_ID]         INT           NULL,
    [REGISTRANT_ID]               INT           NULL,
    [TYPE]                        VARCHAR (100) NULL,
    [PHONE_NUMBER]                VARCHAR (50)  NULL,
    [CREATEDBY]                   VARCHAR (30)  NULL,
    [UPDATEDBY]                   VARCHAR (30)  NULL,
    [CREATED]                     DATETIME2 (7) NULL,
    [UPDATED]                     DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_PHONE_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_PHONE_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_HEALTH_FACTOR_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR_H] (
    [Audit_REGISTRANT_HEALTH_FACTOR_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                          DATETIME      NOT NULL,
    [Audit_Type]                          VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]               VARCHAR (128) NULL,
    [Audit_SQLUser]                       VARCHAR (100) NULL,
    [REGISTRANT_HEALTH_FACTOR_ID]         INT           NULL,
    [REGISTRANT_EVALUATION_ID]            INT           NULL,
    [STD_HEALTH_FACTOR_ID]                SMALLINT      NULL,
    [ACTIVE_FLAG]                         BIT           NULL,
    [CREATEDBY]                           VARCHAR (30)  NULL,
    [UPDATEDBY]                           VARCHAR (30)  NULL,
    [CREATED]                             DATETIME2 (7) NULL,
    [UPDATED]                             DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_HEALTH_FACTOR_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_HEALTH_FACTOR_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_H] (
    [Audit_REGISTRANT_H_ID]                  INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                             DATETIME      NOT NULL,
    [Audit_Type]                             VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]                  VARCHAR (128) NULL,
    [Audit_SQLUser]                          VARCHAR (100) NULL,
    [REGISTRANT_ID]                          INT           NULL,
    [USER_ID]                                VARCHAR (100) NULL,
    [EDIPI]                                  VARCHAR (50)  NULL,
    [ICN]                                    VARCHAR (50)  NULL,
    [SSN]                                    VARCHAR (20)  NULL,
    [FIRST_NAME]                             VARCHAR (50)  NULL,
    [MIDDLE_NAME]                            VARCHAR (50)  NULL,
    [LAST_NAME]                              VARCHAR (50)  NULL,
    [BIRTH_DATE]                             DATE          NULL,
    [GENDER]                                 VARCHAR (50)  NULL,
    [STD_RACE_ID]                            INT           NULL,
    [STD_ETHNICITY_ID]                       INT           NULL,
    [EMAIL]                                  VARCHAR (256) NULL,
    [STD_SERVICE_STATUS_ID]                  INT           NULL,
    [STD_BRANCH_OF_SERVICE_ID_CURRENT]       INT           NULL,
    [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED] INT           NULL,
    [UIC_CURRENT]                            CHAR (1)      NULL,
    [UIC_WHEN_ENROLLED]                      CHAR (1)      NULL,
    [STD_REGISTRANT_STATUS_ID]               INT           NULL,
    [REGISTRANT_STATUS_LAST_UPDATED_DATE]    DATETIME2 (7) NULL,
    [STD_INSTITUTION_ID]                     INT           NULL,
    [MARITAL_STATUS_ID]                      INT           NULL,
    [EDUCATION_LEVEL_ID]                     VARCHAR (50)  NULL,
    [MILITARY_SEPERATION_TYPE_CURRENT]       VARCHAR (50)  NULL,
    [MILITARY_SEPERATION_DATE_CURRENT]       DATE          NULL,
    [MILITARY_SEPERATION_TYPE_WHEN_ENROLLED] VARCHAR (50)  NULL,
    [MILITARY_SEPERATION_DATE_WHEN_ENROLLED] DATE          NULL,
    [HEALTH_CONCERNS_RESPONSE]               VARCHAR (50)  NULL,
    [REQUEST_SEEN_RESPONSE]                  VARCHAR (50)  NULL,
    [DECEASED_FLAG]                          BIT           NULL,
    [DEATH_DATE]                             DATE          NULL,
    [CREATEDBY]                              VARCHAR (30)  NULL,
    [UPDATEDBY]                              VARCHAR (30)  NULL,
    [CREATED]                                DATETIME2 (7) NULL,
    [UPDATED]                                DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EVALUATION_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_EVALUATION_H] (
    [Audit_REGISTRANT_EVALUATION_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                       DATETIME      NOT NULL,
    [Audit_Type]                       VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]            VARCHAR (128) NULL,
    [Audit_SQLUser]                    VARCHAR (100) NULL,
    [REGISTRANT_EVALUATION_ID]         INT           NULL,
    [EVALUATION_DATE_TIME]             DATETIME2 (7) NULL,
    [STD_INSTITUTION_ID]               INT           NULL,
    [CDW_AmbEncSID]                    BIGINT        NULL,
    [VISTA_EncounterID]                VARCHAR (50)  NULL,
    [VISTA_Sta3n]                      SMALLINT      NULL,
    [VISTA_PatientIEN]                 VARCHAR (50)  NULL,
    [VISTA_Sta6a]                      VARCHAR (50)  NULL,
    [VISTA_AppointmentTypeIEN]         VARCHAR (50)  NULL,
    [VISTA_EligibilityIEN]             VARCHAR (20)  NULL,
    [REGISTRANT_ID]                    INT           NULL,
    [CREATEDBY]                        VARCHAR (30)  NULL,
    [UPDATEDBY]                        VARCHAR (30)  NULL,
    [CREATED]                          DATETIME2 (7) NULL,
    [UPDATED]                          DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_EVALUATION_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_EVALUATION_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_EMAIL_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_EMAIL_H] (
    [Audit_REGISTRANT_EMAIL_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                  DATETIME      NOT NULL,
    [Audit_Type]                  VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]       VARCHAR (128) NULL,
    [Audit_SQLUser]               VARCHAR (100) NULL,
    [REGISTRANT_EMAIL_ID]         INT           NULL,
    [REGISTRANT_ID]               INT           NULL,
    [TYPE]                        VARCHAR (100) NULL,
    [EMAIL]                       VARCHAR (256) NULL,
    [CREATEDBY]                   VARCHAR (30)  NULL,
    [UPDATEDBY]                   VARCHAR (30)  NULL,
    [CREATED]                     DATETIME2 (7) NULL,
    [UPDATED]                     DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_EMAIL_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_EMAIL_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_DEPLOYMENT_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT_H] (
    [Audit_REGISTRANT_DEPLOYMENT_H_ID] INT            IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                       DATETIME       NOT NULL,
    [Audit_Type]                       VARCHAR (20)   NOT NULL,
    [Audit_ApplicationUser]            VARCHAR (128)  NULL,
    [Audit_SQLUser]                    VARCHAR (100)  NULL,
    [REGISTRANT_DEPLOYMENT_ID]         INT            NULL,
    [REGISTRANT_ID]                    INT            NULL,
    [STD_BRANCH_OF_SERVICE_ID]         INT            NULL,
    [DUTY_PROJECT_CODE]                VARCHAR (100)  NULL,
    [OCCUPATION_SPECIALTY_CODE]        VARCHAR (50)   NULL,
    [MILITARY_RANK]                    VARCHAR (50)   NULL,
    [DEPLOYMENT_UIC]                   CHAR (1)       NULL,
    [DEPLOYMENT_COUNTRY]               VARCHAR (100)  NULL,
    [DEPLOYMENT_BASE]                  VARCHAR (255)  NULL,
    [DEPLOYMENT_START_DATE]            DATETIME2 (7)  NULL,
    [DEPLOYMENT_END_DATE]              DATETIME2 (7)  NULL,
    [IS_GULF_WAR_VETERAN_FLAG]         BIT            NULL,
    [IS_ELIGIBLE_FLAG]                 BIT            NULL,
    [USER_ENTERED_FLAG]                BIT            NULL,
    [USER_VERIFIED_FLAG]               BIT            NULL,
    [LAST_UPDATED_DATE]                DATETIME2 (7)  NULL,
    [PREVIOUS_VALUES]                  VARCHAR (4000) NULL,
    [PREVIOUS_UPDATED_DATE]            DATETIME2 (7)  NULL,
    [CREATEDBY]                        VARCHAR (30)   NULL,
    [UPDATEDBY]                        VARCHAR (30)   NULL,
    [CREATED]                          DATETIME2 (7)  NULL,
    [UPDATED]                          DATETIME2 (7)  NULL,
    CONSTRAINT [REGISTRANT_DEPLOYMENT_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_DEPLOYMENT_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_CONTACT_INFO_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_CONTACT_INFO_H] (
    [Audit_REGISTRANT_CONTACT_INFO_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                         DATETIME      NOT NULL,
    [Audit_Type]                         VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]              VARCHAR (128) NULL,
    [Audit_SQLUser]                      VARCHAR (100) NULL,
    [REGISTRANT_ID]                      INT           NULL,
    [FIRST_NAME_CONFIRMED]               VARCHAR (50)  NULL,
    [MIDDLE_NAME_CONFIRMED]              VARCHAR (50)  NULL,
    [LAST_NAME_CONFIRMED]                VARCHAR (50)  NULL,
    [LAST_UPDATED_DATE]                  DATETIME2 (7) NULL,
    [PREVIOUS_VALUES]                    VARCHAR (MAX) NULL,
    [PREVIOUS_UPDATED_DATE]              DATETIME2 (7) NULL,
    [CREATEDBY]                          VARCHAR (30)  NULL,
    [UPDATEDBY]                          VARCHAR (30)  NULL,
    [CREATED]                            DATETIME2 (7) NULL,
    [UPDATED]                            DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_CONTACT_INFO_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_CONTACT_INFO_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[REGISTRANT_ADDRESS_H]...';


GO
CREATE TABLE [AHOBPR].[REGISTRANT_ADDRESS_H] (
    [Audit_REGISTRANT_ADDRESS_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                    DATETIME      NOT NULL,
    [Audit_Type]                    VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]         VARCHAR (128) NULL,
    [Audit_SQLUser]                 VARCHAR (100) NULL,
    [REGISTRANT_ADDRESS_ID]         INT           NULL,
    [REGISTRANT_ID]                 INT           NULL,
    [TYPE]                          VARCHAR (100) NULL,
    [STREET1]                       VARCHAR (256) NULL,
    [STREET2]                       VARCHAR (256) NULL,
    [CITY]                          VARCHAR (100) NULL,
    [STATE]                         VARCHAR (100) NULL,
    [ZIP]                           VARCHAR (15)  NULL,
    [COUNTRY]                       VARCHAR (100) NULL,
    [CREATEDBY]                     VARCHAR (30)  NULL,
    [UPDATEDBY]                     VARCHAR (30)  NULL,
    [CREATED]                       DATETIME2 (7) NULL,
    [UPDATED]                       DATETIME2 (7) NULL,
    CONSTRAINT [REGISTRANT_ADDRESS_H_PK] PRIMARY KEY CLUSTERED ([Audit_REGISTRANT_ADDRESS_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[PROCESS_METRICS_H]...';


GO
CREATE TABLE [AHOBPR].[PROCESS_METRICS_H] (
    [Audit_PROCESS_METRICS_H_ID]  INT            IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                  DATETIME       NOT NULL,
    [Audit_Type]                  VARCHAR (20)   NOT NULL,
    [Audit_ApplicationUser]       VARCHAR (128)  NULL,
    [Audit_SQLUser]               VARCHAR (100)  NULL,
    [PROCESS_METRICS_ID]          INT            NULL,
    [REGISTRANT_ID]               INT            NULL,
    [STD_PROCESS_METRICS_TYPE_ID] INT            NULL,
    [PROCESS_METRICS_VALUE]       VARCHAR (1000) NULL,
    [CREATEDBY]                   VARCHAR (30)   NULL,
    [UPDATEDBY]                   VARCHAR (30)   NULL,
    [CREATED]                     DATETIME2 (7)  NULL,
    [UPDATED]                     DATETIME2 (7)  NULL,
    CONSTRAINT [PROCESS_METRICS_H_PK] PRIMARY KEY CLUSTERED ([Audit_PROCESS_METRICS_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_STATUS_H]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_STATUS_H] (
    [Audit_FORM_RESPONSE_STATUS_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                      DATETIME      NOT NULL,
    [Audit_Type]                      VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]           VARCHAR (128) NULL,
    [Audit_SQLUser]                   VARCHAR (100) NULL,
    [FORM_RESPONSE_STATUS_ID]         INT           NULL,
    [FORM_RESPONSE_ID]                INT           NULL,
    [LAST_SECTION_ID]                 INT           NULL,
    [LAST_SUB_SECTION_ID]             INT           NULL,
    [QUESTIONNAIRE_STARTED_DATE]      DATETIME2 (7) NULL,
    [QUESTIONNAIRE_COMPLETED_DATE]    DATETIME2 (7) NULL,
    [CREATEDBY]                       VARCHAR (30)  NULL,
    [UPDATEDBY]                       VARCHAR (30)  NULL,
    [CREATED]                         DATETIME2 (7) NULL,
    [UPDATED]                         DATETIME2 (7) NULL,
    CONSTRAINT [FORM_RESPONSE_STATUS_H_PK] PRIMARY KEY CLUSTERED ([Audit_FORM_RESPONSE_STATUS_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION_H]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_QUESTION_H] (
    [Audit_FORM_RESPONSE_QUESTION_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                        DATETIME      NOT NULL,
    [Audit_Type]                        VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]             VARCHAR (128) NULL,
    [Audit_SQLUser]                     VARCHAR (100) NULL,
    [FORM_RESPONSE_QUESTION_ID]         INT           NULL,
    [FORM_RESPONSE_ID]                  INT           NULL,
    [STD_FORM_QUESTION_ID]              INT           NULL,
    [REGISTRANT_DEPLOYMENT_ID]          INT           NULL,
    [STARTED_DATE]                      DATETIME2 (7) NULL,
    [COMPLETED_DATE]                    DATETIME2 (7) NULL,
    [CREATEDBY]                         VARCHAR (30)  NULL,
    [UPDATEDBY]                         VARCHAR (30)  NULL,
    [CREATED]                           DATETIME2 (7) NULL,
    [UPDATED]                           DATETIME2 (7) NULL,
    CONSTRAINT [FORM_RESPONSE_QUESTION_H_PK] PRIMARY KEY CLUSTERED ([Audit_FORM_RESPONSE_QUESTION_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_H]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_H] (
    [Audit_FORM_RESPONSE_H_ID] INT           IDENTITY (1, 1) NOT NULL,
    [Audit_Date]               DATETIME      NOT NULL,
    [Audit_Type]               VARCHAR (20)  NOT NULL,
    [Audit_ApplicationUser]    VARCHAR (128) NULL,
    [Audit_SQLUser]            VARCHAR (100) NULL,
    [FORM_RESPONSE_ID]         INT           NULL,
    [REGISTRANT_ID]            INT           NULL,
    [STD_FORM_ID]              INT           NULL,
    [CREATEDBY]                VARCHAR (30)  NULL,
    [UPDATEDBY]                VARCHAR (30)  NULL,
    [CREATED]                  DATETIME2 (7) NULL,
    [UPDATED]                  DATETIME2 (7) NULL,
    CONSTRAINT [FORM_RESPONSE_H_PK] PRIMARY KEY CLUSTERED ([Audit_FORM_RESPONSE_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER_H]...';


GO
CREATE TABLE [AHOBPR].[FORM_RESPONSE_ANSWER_H] (
    [Audit_FORM_RESPONSE_ANSWER_H_ID] INT            IDENTITY (1, 1) NOT NULL,
    [Audit_Date]                      DATETIME       NOT NULL,
    [Audit_Type]                      VARCHAR (20)   NOT NULL,
    [Audit_ApplicationUser]           VARCHAR (128)  NULL,
    [Audit_SQLUser]                   VARCHAR (100)  NULL,
    [FORM_RESPONSE_ANSWER_ID]         INT            NULL,
    [FORM_RESPONSE_QUESTION_ID]       INT            NULL,
    [STD_FORM_ANSWER_ID]              INT            NULL,
    [ANSWER_VALUE]                    VARCHAR (4000) NULL,
    [CREATEDBY]                       VARCHAR (30)   NULL,
    [UPDATEDBY]                       VARCHAR (30)   NULL,
    [CREATED]                         DATETIME2 (7)  NULL,
    [UPDATED]                         DATETIME2 (7)  NULL,
    CONSTRAINT [FORM_RESPONSE_ANSWER_H_PK] PRIMARY KEY CLUSTERED ([Audit_FORM_RESPONSE_ANSWER_H_ID] ASC)
);


GO
PRINT N'Creating [AHOBPR].[DF_STD_CONCEPT_CREATED]...';


GO
ALTER TABLE [AHOBPR].[STD_CONCEPT]
    ADD CONSTRAINT [DF_STD_CONCEPT_CREATED] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_STD_CONCEPT_UPDATED]...';


GO
ALTER TABLE [AHOBPR].[STD_CONCEPT]
    ADD CONSTRAINT [DF_STD_CONCEPT_UPDATED] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_STD_TERM_CREATED]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM]
    ADD CONSTRAINT [DF_STD_TERM_CREATED] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_STD_TERM_UPDATED]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM]
    ADD CONSTRAINT [DF_STD_TERM_UPDATED] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormAnswer_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER]
    ADD CONSTRAINT [DF_StdFormAnswer_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormAnswer_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER]
    ADD CONSTRAINT [DF_StdFormAnswer_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormAnswerField_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER_FIELD]
    ADD CONSTRAINT [DF_StdFormAnswerField_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormAnswerField_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER_FIELD]
    ADD CONSTRAINT [DF_StdFormAnswerField_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormPostReqXref_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_POST_REQ_XREF]
    ADD CONSTRAINT [DF_StdFormPostReqXref_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormPostReqXref_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_POST_REQ_XREF]
    ADD CONSTRAINT [DF_StdFormPostReqXref_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormPreReqXref_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_PRE_REQ_XREF]
    ADD CONSTRAINT [DF_StdFormPreReqXref_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormPreReqXref_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_PRE_REQ_XREF]
    ADD CONSTRAINT [DF_StdFormPreReqXref_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormSection_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SECTION]
    ADD CONSTRAINT [DF_StdFormSection_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormSection_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SECTION]
    ADD CONSTRAINT [DF_StdFormSection_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormSubSection_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SUB_SECTION]
    ADD CONSTRAINT [DF_StdFormSubSection_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdFormSubSection_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SUB_SECTION]
    ADD CONSTRAINT [DF_StdFormSubSection_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdRegistrantStatus_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRANT_STATUS]
    ADD CONSTRAINT [DF_StdRegistrantStatus_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdRegistrantStatus_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRANT_STATUS]
    ADD CONSTRAINT [DF_StdRegistrantStatus_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdRegistryFlagType_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG_TYPE]
    ADD CONSTRAINT [DF_StdRegistryFlagType_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdRegistryFlagType_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG_TYPE]
    ADD CONSTRAINT [DF_StdRegistryFlagType_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_STD_REGISTRY_FLAG_TYPE_ACTIVE_FLAG]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG_TYPE]
    ADD CONSTRAINT [DF_STD_REGISTRY_FLAG_TYPE_ACTIVE_FLAG] DEFAULT ((1)) FOR [ACTIVE_FLAG];


GO
PRINT N'Creating [AHOBPR].[DF_StdDeploymentLocation_UserAddedFlag]...';


GO
ALTER TABLE [AHOBPR].[STD_DEPLOYMENT_LOCATION]
    ADD CONSTRAINT [DF_StdDeploymentLocation_UserAddedFlag] DEFAULT 0 FOR [USER_ADDED_FLAG];


GO
PRINT N'Creating [AHOBPR].[DF_STD_REGISTRY_FLAG_ACTIVE_FLAG]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG]
    ADD CONSTRAINT [DF_STD_REGISTRY_FLAG_ACTIVE_FLAG] DEFAULT ((1)) FOR [ACTIVE_FLAG];


GO
PRINT N'Creating [AHOBPR].[DF_STD_REGISTRY_FLAG_PREDEFINED]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG]
    ADD CONSTRAINT [DF_STD_REGISTRY_FLAG_PREDEFINED] DEFAULT ((0)) FOR [PREDEFINED];


GO
PRINT N'Creating [AHOBPR].[DF_StdRegistryFlag_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG]
    ADD CONSTRAINT [DF_StdRegistryFlag_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdRegistryFlag_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG]
    ADD CONSTRAINT [DF_StdRegistryFlag_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_ErrorLog_Created]...';


GO
ALTER TABLE [AHOBPR].[ERROR_LOG]
    ADD CONSTRAINT [DF_ErrorLog_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_ErrorLog_Updated]...';


GO
ALTER TABLE [AHOBPR].[ERROR_LOG]
    ADD CONSTRAINT [DF_ErrorLog_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdHealthFactor_ActiveFlag]...';


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR]
    ADD CONSTRAINT [DF_StdHealthFactor_ActiveFlag] DEFAULT 1 FOR [ACTIVE_FLAG];


GO
PRINT N'Creating [AHOBPR].[DF_StdHealthFactor_Created]...';


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR]
    ADD CONSTRAINT [DF_StdHealthFactor_Created] DEFAULT getdate() FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdHealthFactor_Updated]...';


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR]
    ADD CONSTRAINT [DF_StdHealthFactor_Updated] DEFAULT getdate() FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_StdHealthFactorCategory_ActiveFlag]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY]
    ADD CONSTRAINT [DF_StdHealthFactorCategory_ActiveFlag] DEFAULT ((1)) FOR [ACTIVE_FLAG];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_StdHealthFactorCategory_Created]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY]
    ADD CONSTRAINT [DF_StdHealthFactorCategory_Created] DEFAULT (getdate()) FOR [CREATED];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_StdHealthFactorCategory_Updated]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY]
    ADD CONSTRAINT [DF_StdHealthFactorCategory_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating unnamed constraint on [AHOBPR].[REGISTRANT_HEALTH_FACTOR]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR]
    ADD DEFAULT ((1)) FOR [ACTIVE_FLAG];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantHealthFactor_Created]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR]
    ADD CONSTRAINT [DF_RegistrantHealthFactor_Created] DEFAULT (getdate()) FOR [CREATED];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantHealthFactor_Updated]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR]
    ADD CONSTRAINT [DF_RegistrantHealthFactor_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantContactInfo_Created]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[REGISTRANT_CONTACT_INFO]
    ADD CONSTRAINT [DF_RegistrantContactInfo_Created] DEFAULT (getdate()) FOR [CREATED];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantContactInfo_Updated]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
ALTER TABLE [AHOBPR].[REGISTRANT_CONTACT_INFO]
    ADD CONSTRAINT [DF_RegistrantContactInfo_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantEvaluaton_Created]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EVALUATION]
    ADD CONSTRAINT [DF_RegistrantEvaluaton_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantEvaluaton_Updated]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EVALUATION]
    ADD CONSTRAINT [DF_RegistrantEvaluaton_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantRegistryFlag_Created]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG]
    ADD CONSTRAINT [DF_RegistrantRegistryFlag_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantRegistryFlag_Updated]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG]
    ADD CONSTRAINT [DF_RegistrantRegistryFlag_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantPhone_Created]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_PHONE]
    ADD CONSTRAINT [DF_RegistrantPhone_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantPhone_Updated]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_PHONE]
    ADD CONSTRAINT [DF_RegistrantPhone_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantEmail_Created]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EMAIL]
    ADD CONSTRAINT [DF_RegistrantEmail_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_RegistrantEmail_Updated]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EMAIL]
    ADD CONSTRAINT [DF_RegistrantEmail_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[DF_Registrant_DeceasedFlag]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT]
    ADD CONSTRAINT [DF_Registrant_DeceasedFlag] DEFAULT ((0)) FOR [DECEASED_FLAG];


GO
PRINT N'Creating [AHOBPR].[DF_FormResponse_Created]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE]
    ADD CONSTRAINT [DF_FormResponse_Created] DEFAULT (getdate()) FOR [CREATED];


GO
PRINT N'Creating [AHOBPR].[DF_FormResponse_Updated]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE]
    ADD CONSTRAINT [DF_FormResponse_Updated] DEFAULT (getdate()) FOR [UPDATED];


GO
PRINT N'Creating [AHOBPR].[FK_STD_TERM_STD_CONCEPT]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_TERM_STD_CONCEPT] FOREIGN KEY ([STD_CONCEPT_ID]) REFERENCES [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_TERM_SYSTEM_STD_TERM]...';


GO
ALTER TABLE [AHOBPR].[STD_TERM] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_TERM_SYSTEM_STD_TERM] FOREIGN KEY ([SYSTEM_STD_TERM_ID]) REFERENCES [AHOBPR].[STD_TERM] ([STD_TERM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_CONCEPT]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_CONCEPT] FOREIGN KEY ([STD_CONCEPT_ID]) REFERENCES [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_FORM_QUESTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM_QUESTION] FOREIGN KEY ([STD_FORM_QUESTION_ID]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_FORM_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM_SECTION] FOREIGN KEY ([STD_FORM_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_STD_FORM_SUB_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_STD_FORM_SUB_SECTION] FOREIGN KEY ([STD_FORM_SUB_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_ANSWER_FIELD_STD_FORM_ANSWER]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_ANSWER_FIELD] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_ANSWER_FIELD_STD_FORM_ANSWER] FOREIGN KEY ([STD_FORM_ANSWER_ID]) REFERENCES [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_POST_REQ_XREF_STD_FORM_ANSWER]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_POST_REQ_XREF] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_POST_REQ_XREF_STD_FORM_ANSWER] FOREIGN KEY ([STD_FORM_ANSWER_ID]) REFERENCES [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_POST_REQ_XREF_STD_FORM_QUESTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_POST_REQ_XREF] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_POST_REQ_XREF_STD_FORM_QUESTION] FOREIGN KEY ([STD_FORM_QUESTION_ID]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_POST_REQ_XREF_STD_FORM_QUESTION_POST_REQ]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_POST_REQ_XREF] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_POST_REQ_XREF_STD_FORM_QUESTION_POST_REQ] FOREIGN KEY ([STD_FORM_QUESTION_ID_POST_REQ]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_PRE_REQ_XREF_STD_FORM_QUESTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_PRE_REQ_XREF] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_PRE_REQ_XREF_STD_FORM_QUESTION] FOREIGN KEY ([STD_FORM_QUESTION_ID]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_PRE_REQ_XREF_STD_FORM_QUESTION_PRE_REQ]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_PRE_REQ_XREF] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_PRE_REQ_XREF_STD_FORM_QUESTION_PRE_REQ] FOREIGN KEY ([STD_FORM_QUESTION_ID_PRE_REQ]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_SECTION_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SECTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_SECTION_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_SUB_SECTION_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SUB_SECTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_SUB_SECTION_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_SUB_SECTION_STD_FORM_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_SUB_SECTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_SUB_SECTION_STD_FORM_SECTION] FOREIGN KEY ([STD_FORM_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_StdRegistryFlag_StdRegistryFlagType]...';


GO
ALTER TABLE [AHOBPR].[STD_REGISTRY_FLAG] WITH NOCHECK
    ADD CONSTRAINT [FK_StdRegistryFlag_StdRegistryFlagType] FOREIGN KEY ([STD_REGISTRY_FLAG_TYPE_ID]) REFERENCES [AHOBPR].[STD_REGISTRY_FLAG_TYPE] ([STD_REGISTRY_FLAG_TYPE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_QUESTION_STD_CONCEPT]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_QUESTION_STD_CONCEPT] FOREIGN KEY ([STD_CONCEPT_ID]) REFERENCES [AHOBPR].[STD_CONCEPT] ([STD_CONCEPT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_QUESTION_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_QUESTION_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_QUESTION_STD_FORM_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_QUESTION_STD_FORM_SECTION] FOREIGN KEY ([STD_FORM_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_STD_FORM_QUESTION_STD_FORM_SUB_SECTION]...';


GO
ALTER TABLE [AHOBPR].[STD_FORM_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_STD_FORM_QUESTION_STD_FORM_SUB_SECTION] FOREIGN KEY ([STD_FORM_SUB_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_StdHealthFactor_StdHealthFactorCategory]...';


GO
ALTER TABLE [AHOBPR].[STD_HEALTH_FACTOR] WITH NOCHECK
    ADD CONSTRAINT [FK_StdHealthFactor_StdHealthFactorCategory] FOREIGN KEY ([STD_HEALTH_FACTOR_CATEGORY_ID]) REFERENCES [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] ([STD_HEALTH_FACTOR_CATEGORY_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantHealthFactor_RegistrantEvaluation]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantHealthFactor_RegistrantEvaluation] FOREIGN KEY ([REGISTRANT_EVALUATION_ID]) REFERENCES [AHOBPR].[REGISTRANT_EVALUATION] ([REGISTRANT_EVALUATION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantHealthFactor_StdHealthFactor]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_HEALTH_FACTOR] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantHealthFactor_StdHealthFactor] FOREIGN KEY ([STD_HEALTH_FACTOR_ID]) REFERENCES [AHOBPR].[STD_HEALTH_FACTOR] ([STD_HEALTH_FACTOR_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_DEPLOYMENT_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantDeployHx_StdBranchOfService]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantDeployHx_StdBranchOfService] FOREIGN KEY ([STD_BRANCH_OF_SERVICE_ID]) REFERENCES [AHOBPR].[STD_BRANCH_OF_SERVICE] ([STD_BRANCH_OF_SERVICE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantContactInfo_Registrant]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_CONTACT_INFO] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantContactInfo_Registrant] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_EVALUATION_REGISTRANT_EVALUATION]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EVALUATION] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_EVALUATION_REGISTRANT_EVALUATION] FOREIGN KEY ([REGISTRANT_EVALUATION_ID]) REFERENCES [AHOBPR].[REGISTRANT_EVALUATION] ([REGISTRANT_EVALUATION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantEvaluation_DboStdInstituion]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EVALUATION] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantEvaluation_DboStdInstituion] FOREIGN KEY ([STD_INSTITUTION_ID]) REFERENCES [dbo].[STD_INSTITUTION] ([ID]);


GO
PRINT N'Creating [AHOBPR].[FK_RegistrantEvaluaton_Registrant]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EVALUATION] WITH NOCHECK
    ADD CONSTRAINT [FK_RegistrantEvaluaton_Registrant] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_SERVICE_EPISODE_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_SERVICE_EPISODE_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_ServiceEpisode_StdBranchOfService]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] WITH NOCHECK
    ADD CONSTRAINT [FK_ServiceEpisode_StdBranchOfService] FOREIGN KEY ([STD_BRANCH_OF_SERVICE_ID]) REFERENCES [AHOBPR].[STD_BRANCH_OF_SERVICE] ([STD_BRANCH_OF_SERVICE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_REGISTRY_FLAG_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_REGISTRY_FLAG_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_REGISTRY_FLAG_STD_REGISTRY_FLAG]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_REGISTRY_FLAG] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_REGISTRY_FLAG_STD_REGISTRY_FLAG] FOREIGN KEY ([STD_REGISTRY_FLAG_ID]) REFERENCES [AHOBPR].[STD_REGISTRY_FLAG] ([STD_REGISTRY_FLAG_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_INFO_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_RECORD_INFO] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_INFO_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_PHONE_REGISTRANT_CONTACT_INFO]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_PHONE] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_PHONE_REGISTRANT_CONTACT_INFO] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT_CONTACT_INFO] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_EMAIL_REGISTRANT_CONTACT_INFO]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_EMAIL] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_EMAIL_REGISTRANT_CONTACT_INFO] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT_CONTACT_INFO] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_ADDRESS_REGISTRANT_CONTACT_INFO]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT_ADDRESS] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_ADDRESS_REGISTRANT_CONTACT_INFO] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT_CONTACT_INFO] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_INSTITUTION]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_INSTITUTION] FOREIGN KEY ([STD_INSTITUTION_ID]) REFERENCES [dbo].[STD_INSTITUTION] ([ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_REGISTRANT_STATUS]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_REGISTRANT_STATUS] FOREIGN KEY ([STD_REGISTRANT_STATUS_ID]) REFERENCES [AHOBPR].[STD_REGISTRANT_STATUS] ([STD_REGISTRANT_STATUS_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_REGISTRANT_STD_SERVICE_STATUS]...';


GO
ALTER TABLE [AHOBPR].[REGISTRANT] WITH NOCHECK
    ADD CONSTRAINT [FK_REGISTRANT_STD_SERVICE_STATUS] FOREIGN KEY ([STD_SERVICE_STATUS_ID]) REFERENCES [AHOBPR].[STD_SERVICE_STATUS] ([STD_SERVICE_STATUS_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_PROCESS_METRICS_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[PROCESS_METRICS] WITH NOCHECK
    ADD CONSTRAINT [FK_PROCESS_METRICS_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_PROCESS_METRICS_STD_PROCESS_METRICS_TYPE]...';


GO
ALTER TABLE [AHOBPR].[PROCESS_METRICS] WITH NOCHECK
    ADD CONSTRAINT [FK_PROCESS_METRICS_STD_PROCESS_METRICS_TYPE] FOREIGN KEY ([STD_PROCESS_METRICS_TYPE_ID]) REFERENCES [AHOBPR].[STD_PROCESS_METRICS_TYPE] ([STD_PROCESS_METRICS_TYPE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_STATUS_FORM_RESPONSE]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_STATUS] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_STATUS_FORM_RESPONSE] FOREIGN KEY ([FORM_RESPONSE_ID]) REFERENCES [AHOBPR].[FORM_RESPONSE] ([FORM_RESPONSE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_STATUS_STD_FORM_SECTION]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_STATUS] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_STATUS_STD_FORM_SECTION] FOREIGN KEY ([LAST_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SECTION] ([STD_FORM_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_STATUS_STD_FORM_SUB_SECTION]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_STATUS] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_STATUS_STD_FORM_SUB_SECTION] FOREIGN KEY ([LAST_SUB_SECTION_ID]) REFERENCES [AHOBPR].[STD_FORM_SUB_SECTION] ([STD_FORM_SUB_SECTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FormResponseQuestion_FORM_RESPONSE]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_FormResponseQuestion_FORM_RESPONSE] FOREIGN KEY ([FORM_RESPONSE_ID]) REFERENCES [AHOBPR].[FORM_RESPONSE] ([FORM_RESPONSE_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FormResponseQuestion_REGISTRANT_DEPLOYMENT_HISTORY]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_FormResponseQuestion_REGISTRANT_DEPLOYMENT_HISTORY] FOREIGN KEY ([REGISTRANT_DEPLOYMENT_ID]) REFERENCES [AHOBPR].[REGISTRANT_DEPLOYMENT] ([REGISTRANT_DEPLOYMENT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FormResponseQuestion_STD_FORM_QUESTION]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_QUESTION] WITH NOCHECK
    ADD CONSTRAINT [FK_FormResponseQuestion_STD_FORM_QUESTION] FOREIGN KEY ([STD_FORM_QUESTION_ID]) REFERENCES [AHOBPR].[STD_FORM_QUESTION] ([STD_FORM_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_ANSWER_FORM_RESPONSE_DETAIL]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_ANSWER_FORM_RESPONSE_DETAIL] FOREIGN KEY ([FORM_RESPONSE_QUESTION_ID]) REFERENCES [AHOBPR].[FORM_RESPONSE_QUESTION] ([FORM_RESPONSE_QUESTION_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_ANSWER_STD_FORM_ANSWER]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE_ANSWER] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_ANSWER_STD_FORM_ANSWER] FOREIGN KEY ([STD_FORM_ANSWER_ID]) REFERENCES [AHOBPR].[STD_FORM_ANSWER] ([STD_FORM_ANSWER_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_REGISTRANT]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Creating [AHOBPR].[FK_FORM_RESPONSE_STD_FORM]...';


GO
ALTER TABLE [AHOBPR].[FORM_RESPONSE] WITH NOCHECK
    ADD CONSTRAINT [FK_FORM_RESPONSE_STD_FORM] FOREIGN KEY ([STD_FORM_ID]) REFERENCES [AHOBPR].[STD_FORM] ([STD_FORM_ID]);


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_HEALTH_FACTOR_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_HEALTH_FACTOR_H] on [AHOBPR].[REGISTRANT_HEALTH_FACTOR]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_HEALTH_FACTOR_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_HEALTH_FACTOR_ID]
, [REGISTRANT_EVALUATION_ID]
, [STD_HEALTH_FACTOR_ID]
, [ACTIVE_FLAG]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_HEALTH_FACTOR_ID]
, [REGISTRANT_EVALUATION_ID]
, [STD_HEALTH_FACTOR_ID]
, [ACTIVE_FLAG]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_HEALTH_FACTOR_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_HEALTH_FACTOR_DEL_H]
on  [AHOBPR].[REGISTRANT_HEALTH_FACTOR] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_HEALTH_FACTOR_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_HEALTH_FACTOR_ID]
, [REGISTRANT_EVALUATION_ID]
, [STD_HEALTH_FACTOR_ID]
, [ACTIVE_FLAG]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_HEALTH_FACTOR_ID]
, [REGISTRANT_EVALUATION_ID]
, [STD_HEALTH_FACTOR_ID]
, [ACTIVE_FLAG]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_DEPLOYMENT_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_DEPLOYMENT_H] on [AHOBPR].[REGISTRANT_DEPLOYMENT]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_DEPLOYMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_DEPLOYMENT_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [DUTY_PROJECT_CODE]
, [OCCUPATION_SPECIALTY_CODE]
, [MILITARY_RANK]
, [DEPLOYMENT_UIC]
, [DEPLOYMENT_COUNTRY]
, [DEPLOYMENT_BASE]
, [DEPLOYMENT_START_DATE]
, [DEPLOYMENT_END_DATE]
, [IS_GULF_WAR_VETERAN_FLAG]
, [IS_ELIGIBLE_FLAG]
, [USER_ENTERED_FLAG]
, [USER_VERIFIED_FLAG]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_DEPLOYMENT_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [DUTY_PROJECT_CODE]
, [OCCUPATION_SPECIALTY_CODE]
, [MILITARY_RANK]
, [DEPLOYMENT_UIC]
, [DEPLOYMENT_COUNTRY]
, [DEPLOYMENT_BASE]
, [DEPLOYMENT_START_DATE]
, [DEPLOYMENT_END_DATE]
, [IS_GULF_WAR_VETERAN_FLAG]
, [IS_ELIGIBLE_FLAG]
, [USER_ENTERED_FLAG]
, [USER_VERIFIED_FLAG]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_DEPLOYMENT_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_DEPLOYMENT_DEL_H]
on  [AHOBPR].[REGISTRANT_DEPLOYMENT] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_DEPLOYMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_DEPLOYMENT_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [DUTY_PROJECT_CODE]
, [OCCUPATION_SPECIALTY_CODE]
, [MILITARY_RANK]
, [DEPLOYMENT_UIC]
, [DEPLOYMENT_COUNTRY]
, [DEPLOYMENT_BASE]
, [DEPLOYMENT_START_DATE]
, [DEPLOYMENT_END_DATE]
, [IS_GULF_WAR_VETERAN_FLAG]
, [IS_ELIGIBLE_FLAG]
, [USER_ENTERED_FLAG]
, [USER_VERIFIED_FLAG]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_DEPLOYMENT_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [DUTY_PROJECT_CODE]
, [OCCUPATION_SPECIALTY_CODE]
, [MILITARY_RANK]
, [DEPLOYMENT_UIC]
, [DEPLOYMENT_COUNTRY]
, [DEPLOYMENT_BASE]
, [DEPLOYMENT_START_DATE]
, [DEPLOYMENT_END_DATE]
, [IS_GULF_WAR_VETERAN_FLAG]
, [IS_ELIGIBLE_FLAG]
, [USER_ENTERED_FLAG]
, [USER_VERIFIED_FLAG]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_CONTACT_INFO_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_CONTACT_INFO_H] on [AHOBPR].[REGISTRANT_CONTACT_INFO]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_CONTACT_INFO_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [FIRST_NAME_CONFIRMED]
, [MIDDLE_NAME_CONFIRMED]
, [LAST_NAME_CONFIRMED]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_ID]
, [FIRST_NAME_CONFIRMED]
, [MIDDLE_NAME_CONFIRMED]
, [LAST_NAME_CONFIRMED]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_CONTACT_INFO_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_CONTACT_INFO_DEL_H]
on  [AHOBPR].[REGISTRANT_CONTACT_INFO] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_CONTACT_INFO_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [FIRST_NAME_CONFIRMED]
, [MIDDLE_NAME_CONFIRMED]
, [LAST_NAME_CONFIRMED]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_ID]
, [FIRST_NAME_CONFIRMED]
, [MIDDLE_NAME_CONFIRMED]
, [LAST_NAME_CONFIRMED]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_EVALUATION_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_EVALUATION_H] on [AHOBPR].[REGISTRANT_EVALUATION]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_EVALUATION_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_EVALUATION_ID]
, [EVALUATION_DATE_TIME]
, [STD_INSTITUTION_ID]
, [CDW_AmbEncSID]
, [VISTA_EncounterID]
, [VISTA_Sta3n]
, [VISTA_PatientIEN]
, [VISTA_Sta6a]
, [VISTA_AppointmentTypeIEN]
, [VISTA_EligibilityIEN]
, [REGISTRANT_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_EVALUATION_ID]
, [EVALUATION_DATE_TIME]
, [STD_INSTITUTION_ID]
, [CDW_AmbEncSID]
, [VISTA_EncounterID]
, [VISTA_Sta3n]
, [VISTA_PatientIEN]
, [VISTA_Sta6a]
, [VISTA_AppointmentTypeIEN]
, [VISTA_EligibilityIEN]
, [REGISTRANT_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_EVALUATION_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_EVALUATION_DEL_H]
on  [AHOBPR].[REGISTRANT_EVALUATION] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_EVALUATION_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_EVALUATION_ID]
, [EVALUATION_DATE_TIME]
, [STD_INSTITUTION_ID]
, [CDW_AmbEncSID]
, [VISTA_EncounterID]
, [VISTA_Sta3n]
, [VISTA_PatientIEN]
, [VISTA_Sta6a]
, [VISTA_AppointmentTypeIEN]
, [VISTA_EligibilityIEN]
, [REGISTRANT_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_EVALUATION_ID]
, [EVALUATION_DATE_TIME]
, [STD_INSTITUTION_ID]
, [CDW_AmbEncSID]
, [VISTA_EncounterID]
, [VISTA_Sta3n]
, [VISTA_PatientIEN]
, [VISTA_Sta6a]
, [VISTA_AppointmentTypeIEN]
, [VISTA_EligibilityIEN]
, [REGISTRANT_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REPORT_SEARCH_CRITERIA_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REPORT_SEARCH_CRITERIA_H] on [AHOBPR].[REPORT_SEARCH_CRITERIA]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REPORT_SEARCH_CRITERIA_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REPORT_SEARCH_CRITERIA_ID]
, [REPORT_NAME]
, [SEARCH_CRITERIA_NAME]
, [SEARCH_CRITERIA]
, [SEARCH_CRITERIA_DESCRIPTION]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REPORT_SEARCH_CRITERIA_ID]
, [REPORT_NAME]
, [SEARCH_CRITERIA_NAME]
, [SEARCH_CRITERIA]
, [SEARCH_CRITERIA_DESCRIPTION]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REPORT_SEARCH_CRITERIA_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REPORT_SEARCH_CRITERIA_DEL_H]
on  [AHOBPR].[REPORT_SEARCH_CRITERIA] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REPORT_SEARCH_CRITERIA_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REPORT_SEARCH_CRITERIA_ID]
, [REPORT_NAME]
, [SEARCH_CRITERIA_NAME]
, [SEARCH_CRITERIA]
, [SEARCH_CRITERIA_DESCRIPTION]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REPORT_SEARCH_CRITERIA_ID]
, [REPORT_NAME]
, [SEARCH_CRITERIA_NAME]
, [SEARCH_CRITERIA]
, [SEARCH_CRITERIA_DESCRIPTION]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_SERVICE_EPISODE_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_SERVICE_EPISODE_H] on [AHOBPR].[REGISTRANT_SERVICE_EPISODE]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_SERVICE_EPISODE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_SERVICE_EPISODE_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [SERVICE_EPISODE_START_DATE]
, [SERVICE_EPISODE_END_DATE]
, [SERVICE_EPISODE_TERMINATION_REASON]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_SERVICE_EPISODE_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [SERVICE_EPISODE_START_DATE]
, [SERVICE_EPISODE_END_DATE]
, [SERVICE_EPISODE_TERMINATION_REASON]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_SERVICE_EPISODE_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_SERVICE_EPISODE_DEL_H]
on  [AHOBPR].[REGISTRANT_SERVICE_EPISODE] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_SERVICE_EPISODE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_SERVICE_EPISODE_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [SERVICE_EPISODE_START_DATE]
, [SERVICE_EPISODE_END_DATE]
, [SERVICE_EPISODE_TERMINATION_REASON]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_SERVICE_EPISODE_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [SERVICE_EPISODE_START_DATE]
, [SERVICE_EPISODE_END_DATE]
, [SERVICE_EPISODE_TERMINATION_REASON]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_REGISTRY_FLAG_H]...';


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_REGISTRY_FLAG_H] on [AHOBPR].[REGISTRANT_REGISTRY_FLAG]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_REGISTRY_FLAG_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_REGISTRY_FLAG_ID]
, [REGISTRANT_ID]
, [STD_REGISTRY_FLAG_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_REGISTRY_FLAG_ID]
, [REGISTRANT_ID]
, [STD_REGISTRY_FLAG_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_REGISTRY_FLAG_DEL_H]...';


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_REGISTRY_FLAG_DEL_H]
on  [AHOBPR].[REGISTRANT_REGISTRY_FLAG] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_REGISTRY_FLAG_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_REGISTRY_FLAG_ID]
, [REGISTRANT_ID]
, [STD_REGISTRY_FLAG_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_REGISTRY_FLAG_ID]
, [REGISTRANT_ID]
, [STD_REGISTRY_FLAG_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_RECORD_INFO_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_RECORD_INFO_H] on [AHOBPR].[REGISTRANT_RECORD_INFO]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_RECORD_INFO_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [EULA_ACCEPTED_DATE]
, [EDIPI_VERIFIED_DATE]
, [EDIPI_MISMATCHED_FLAG]
, [CONTACT_INFO_VERIFIED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_ID]
, [EULA_ACCEPTED_DATE]
, [EDIPI_VERIFIED_DATE]
, [EDIPI_MISMATCHED_FLAG]
, [CONTACT_INFO_VERIFIED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_RECORD_INFO_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_RECORD_INFO_DEL_H]
on  [AHOBPR].[REGISTRANT_RECORD_INFO] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_RECORD_INFO_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [EULA_ACCEPTED_DATE]
, [EDIPI_VERIFIED_DATE]
, [EDIPI_MISMATCHED_FLAG]
, [CONTACT_INFO_VERIFIED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_ID]
, [EULA_ACCEPTED_DATE]
, [EDIPI_VERIFIED_DATE]
, [EDIPI_MISMATCHED_FLAG]
, [CONTACT_INFO_VERIFIED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_PHONE_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_PHONE_H] on [AHOBPR].[REGISTRANT_PHONE]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_PHONE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_PHONE_ID]
, [REGISTRANT_ID]
, [TYPE]
, [PHONE_NUMBER]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_PHONE_ID]
, [REGISTRANT_ID]
, [TYPE]
, [PHONE_NUMBER]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_PHONE_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_PHONE_DEL_H]
on  [AHOBPR].[REGISTRANT_PHONE] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_PHONE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_PHONE_ID]
, [REGISTRANT_ID]
, [TYPE]
, [PHONE_NUMBER]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_PHONE_ID]
, [REGISTRANT_ID]
, [TYPE]
, [PHONE_NUMBER]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_EMAIL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_EMAIL_H] on [AHOBPR].[REGISTRANT_EMAIL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_EMAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_EMAIL_ID]
, [REGISTRANT_ID]
, [TYPE]
, [EMAIL]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_EMAIL_ID]
, [REGISTRANT_ID]
, [TYPE]
, [EMAIL]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_EMAIL_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_EMAIL_DEL_H]
on  [AHOBPR].[REGISTRANT_EMAIL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_EMAIL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_EMAIL_ID]
, [REGISTRANT_ID]
, [TYPE]
, [EMAIL]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_EMAIL_ID]
, [REGISTRANT_ID]
, [TYPE]
, [EMAIL]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_ADDRESS_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_ADDRESS_H] on [AHOBPR].[REGISTRANT_ADDRESS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_ADDRESS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ADDRESS_ID]
, [REGISTRANT_ID]
, [TYPE]
, [STREET1]
, [STREET2]
, [CITY]
, [STATE]
, [ZIP]
, [COUNTRY]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_ADDRESS_ID]
, [REGISTRANT_ID]
, [TYPE]
, [STREET1]
, [STREET2]
, [CITY]
, [STATE]
, [ZIP]
, [COUNTRY]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_ADDRESS_DEL_H]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_ADDRESS_DEL_H]
on  [AHOBPR].[REGISTRANT_ADDRESS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_ADDRESS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ADDRESS_ID]
, [REGISTRANT_ID]
, [TYPE]
, [STREET1]
, [STREET2]
, [CITY]
, [STATE]
, [ZIP]
, [COUNTRY]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_ADDRESS_ID]
, [REGISTRANT_ID]
, [TYPE]
, [STREET1]
, [STREET2]
, [CITY]
, [STATE]
, [ZIP]
, [COUNTRY]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_Ins_Upd]...';


GO

CREATE TRIGGER [AHOBPR].[TRG_REGISTRANT_Ins_Upd]
    ON [AHOBPR].[REGISTRANT]
    FOR INSERT, UPDATE
    AS
    BEGIN
        SET NoCount ON
        DECLARE @MetricsTypeId int = (SELECT STD_PROCESS_METRICS_TYPE_ID FROM STD_PROCESS_METRICS_TYPE WHERE PROCESS_METRICS  = 'Registrant Status Change');

        --set the [REGISTRANT_STATUS_LAST_UPDATED_DATE] field if a status change is detected
        UPDATE  [AHOBPR].[REGISTRANT]
          SET   [REGISTRANT_STATUS_LAST_UPDATED_DATE] = UPDATED
          WHERE NOT EXISTS (
                              SELECT  *
                              FROM    deleted
                              INNER
                              JOIN    inserted
                                ON    inserted.REGISTRANT_ID = deleted.REGISTRANT_ID
                              WHERE   
                                      inserted.REGISTRANT_ID            = deleted.REGISTRANT_ID
                                  AND inserted.STD_REGISTRANT_STATUS_ID = deleted.STD_REGISTRANT_STATUS_ID
                                  AND [REGISTRANT].REGISTRANT_ID = inserted.REGISTRANT_ID
                            )
                AND [REGISTRANT_STATUS_LAST_UPDATED_DATE] != UPDATED;

        --Insert a 'Registrant Status Change' events into AHOBPR.PROCESS_METRICS if changes are detected
        INSERT   
          INTO    AHOBPR.PROCESS_METRICS 
                  (
                    [REGISTRANT_ID],
                    [STD_PROCESS_METRICS_TYPE_ID],
                    [PROCESS_METRICS_VALUE],
                    [CREATEDBY],
                    [UPDATEDBY],
                    [CREATED],
                    [UPDATED]
                  )
          SELECT  [REGISTRANT_ID],
                  @MetricsTypeId,
                  s.REGISTRANT_STATUS,
                  inserted.[UPDATEDBY],
                  inserted.[UPDATEDBY],
                  inserted.[UPDATED],
                  inserted.[UPDATED]
          FROM
                  inserted
          JOIN    AHOBPR.STD_REGISTRANT_STATUS AS s
            ON    s.STD_REGISTRANT_STATUS_ID = inserted.STD_REGISTRANT_STATUS_ID
          WHERE   NOT EXISTS (
                              SELECT  *
                              FROM    deleted
                              WHERE   inserted.REGISTRANT_ID            = deleted.REGISTRANT_ID
                                  AND inserted.STD_REGISTRANT_STATUS_ID = deleted.STD_REGISTRANT_STATUS_ID
                            );
        
    END
GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_H]...';


GO
Create trigger [AHOBPR].[TRG_REGISTRANT_H] on [AHOBPR].[REGISTRANT]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [USER_ID]
, [EDIPI]
, [ICN]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [BIRTH_DATE]
, [GENDER]
, [STD_RACE_ID]
, [STD_ETHNICITY_ID]
, [EMAIL]
, [STD_SERVICE_STATUS_ID]
, [STD_BRANCH_OF_SERVICE_ID_CURRENT]
, [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED]
, [UIC_CURRENT]
, [UIC_WHEN_ENROLLED]
, [STD_REGISTRANT_STATUS_ID]
, [REGISTRANT_STATUS_LAST_UPDATED_DATE]
, [STD_INSTITUTION_ID]
, [MARITAL_STATUS_ID]
, [EDUCATION_LEVEL_ID]
, [MILITARY_SEPERATION_TYPE_CURRENT]
, [MILITARY_SEPERATION_DATE_CURRENT]
, [MILITARY_SEPERATION_TYPE_WHEN_ENROLLED]
, [MILITARY_SEPERATION_DATE_WHEN_ENROLLED]
, [HEALTH_CONCERNS_RESPONSE]
, [REQUEST_SEEN_RESPONSE]
, [DECEASED_FLAG]
, [DEATH_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_ID]
, [USER_ID]
, [EDIPI]
, [ICN]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [BIRTH_DATE]
, [GENDER]
, [STD_RACE_ID]
, [STD_ETHNICITY_ID]
, [EMAIL]
, [STD_SERVICE_STATUS_ID]
, [STD_BRANCH_OF_SERVICE_ID_CURRENT]
, [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED]
, [UIC_CURRENT]
, [UIC_WHEN_ENROLLED]
, [STD_REGISTRANT_STATUS_ID]
, [REGISTRANT_STATUS_LAST_UPDATED_DATE]
, [STD_INSTITUTION_ID]
, [MARITAL_STATUS_ID]
, [EDUCATION_LEVEL_ID]
, [MILITARY_SEPERATION_TYPE_CURRENT]
, [MILITARY_SEPERATION_DATE_CURRENT]
, [MILITARY_SEPERATION_TYPE_WHEN_ENROLLED]
, [MILITARY_SEPERATION_DATE_WHEN_ENROLLED]
, [HEALTH_CONCERNS_RESPONSE]
, [REQUEST_SEEN_RESPONSE]
, [DECEASED_FLAG]
, [DEATH_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
PRINT N'Creating [AHOBPR].[TRG_REGISTRANT_DEL_H]...';


GO
CREATE TRIGGER  [AHOBPR].[TRG_REGISTRANT_DEL_H]
on  [AHOBPR].[REGISTRANT] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [USER_ID]
, [EDIPI]
, [ICN]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [BIRTH_DATE]
, [GENDER]
, [STD_RACE_ID]
, [STD_ETHNICITY_ID]
, [EMAIL]
, [STD_SERVICE_STATUS_ID]
, [STD_BRANCH_OF_SERVICE_ID_CURRENT]
, [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED]
, [UIC_CURRENT]
, [UIC_WHEN_ENROLLED]
, [STD_REGISTRANT_STATUS_ID]
, [REGISTRANT_STATUS_LAST_UPDATED_DATE]
, [STD_INSTITUTION_ID]
, [MARITAL_STATUS_ID]
, [EDUCATION_LEVEL_ID]
, [MILITARY_SEPERATION_TYPE_CURRENT]
, [MILITARY_SEPERATION_DATE_CURRENT]
, [MILITARY_SEPERATION_TYPE_WHEN_ENROLLED]
, [MILITARY_SEPERATION_DATE_WHEN_ENROLLED]
, [HEALTH_CONCERNS_RESPONSE]
, [REQUEST_SEEN_RESPONSE]
, [DECEASED_FLAG]
, [DEATH_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_ID]
, [USER_ID]
, [EDIPI]
, [ICN]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [BIRTH_DATE]
, [GENDER]
, [STD_RACE_ID]
, [STD_ETHNICITY_ID]
, [EMAIL]
, [STD_SERVICE_STATUS_ID]
, [STD_BRANCH_OF_SERVICE_ID_CURRENT]
, [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED]
, [UIC_CURRENT]
, [UIC_WHEN_ENROLLED]
, [STD_REGISTRANT_STATUS_ID]
, [REGISTRANT_STATUS_LAST_UPDATED_DATE]
, [STD_INSTITUTION_ID]
, [MARITAL_STATUS_ID]
, [EDUCATION_LEVEL_ID]
, [MILITARY_SEPERATION_TYPE_CURRENT]
, [MILITARY_SEPERATION_DATE_CURRENT]
, [MILITARY_SEPERATION_TYPE_WHEN_ENROLLED]
, [MILITARY_SEPERATION_DATE_WHEN_ENROLLED]
, [HEALTH_CONCERNS_RESPONSE]
, [REQUEST_SEEN_RESPONSE]
, [DECEASED_FLAG]
, [DEATH_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
PRINT N'Creating [AHOBPR].[TRG_PROCESS_METRICS_H]...';


GO
Create trigger [AHOBPR].[TRG_PROCESS_METRICS_H] on [AHOBPR].[PROCESS_METRICS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[PROCESS_METRICS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [PROCESS_METRICS_ID]
, [REGISTRANT_ID]
, [STD_PROCESS_METRICS_TYPE_ID]
, [PROCESS_METRICS_VALUE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [PROCESS_METRICS_ID]
, [REGISTRANT_ID]
, [STD_PROCESS_METRICS_TYPE_ID]
, [PROCESS_METRICS_VALUE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
PRINT N'Creating [AHOBPR].[TRG_PROCESS_METRICS_DEL_H]...';


GO
CREATE TRIGGER  [AHOBPR].[TRG_PROCESS_METRICS_DEL_H]
on  [AHOBPR].[PROCESS_METRICS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[PROCESS_METRICS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [PROCESS_METRICS_ID]
, [REGISTRANT_ID]
, [STD_PROCESS_METRICS_TYPE_ID]
, [PROCESS_METRICS_VALUE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [PROCESS_METRICS_ID]
, [REGISTRANT_ID]
, [STD_PROCESS_METRICS_TYPE_ID]
, [PROCESS_METRICS_VALUE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_STATUS_H]...';


GO
Create trigger [AHOBPR].[TRG_FORM_RESPONSE_STATUS_H] on [AHOBPR].[FORM_RESPONSE_STATUS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[FORM_RESPONSE_STATUS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_STATUS_ID]
, [FORM_RESPONSE_ID]
, [LAST_SECTION_ID]
, [LAST_SUB_SECTION_ID]
, [QUESTIONNAIRE_STARTED_DATE]
, [QUESTIONNAIRE_COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [FORM_RESPONSE_STATUS_ID]
, [FORM_RESPONSE_ID]
, [LAST_SECTION_ID]
, [LAST_SUB_SECTION_ID]
, [QUESTIONNAIRE_STARTED_DATE]
, [QUESTIONNAIRE_COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_STATUS_DEL_H]...';


GO
CREATE TRIGGER  [AHOBPR].[TRG_FORM_RESPONSE_STATUS_DEL_H]
on  [AHOBPR].[FORM_RESPONSE_STATUS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[FORM_RESPONSE_STATUS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_STATUS_ID]
, [FORM_RESPONSE_ID]
, [LAST_SECTION_ID]
, [LAST_SUB_SECTION_ID]
, [QUESTIONNAIRE_STARTED_DATE]
, [QUESTIONNAIRE_COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [FORM_RESPONSE_STATUS_ID]
, [FORM_RESPONSE_ID]
, [LAST_SECTION_ID]
, [LAST_SUB_SECTION_ID]
, [QUESTIONNAIRE_STARTED_DATE]
, [QUESTIONNAIRE_COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_QUESTION_H]...';


GO
Create trigger [AHOBPR].[TRG_FORM_RESPONSE_QUESTION_H] on [AHOBPR].[FORM_RESPONSE_QUESTION]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[FORM_RESPONSE_QUESTION_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_QUESTION_ID]
, [FORM_RESPONSE_ID]
, [STD_FORM_QUESTION_ID]
, [REGISTRANT_DEPLOYMENT_ID]
, [STARTED_DATE]
, [COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [FORM_RESPONSE_QUESTION_ID]
, [FORM_RESPONSE_ID]
, [STD_FORM_QUESTION_ID]
, [REGISTRANT_DEPLOYMENT_ID]
, [STARTED_DATE]
, [COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_QUESTION_DEL_H]...';


GO
CREATE TRIGGER  [AHOBPR].[TRG_FORM_RESPONSE_QUESTION_DEL_H]
on  [AHOBPR].[FORM_RESPONSE_QUESTION] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[FORM_RESPONSE_QUESTION_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_QUESTION_ID]
, [FORM_RESPONSE_ID]
, [STD_FORM_QUESTION_ID]
, [REGISTRANT_DEPLOYMENT_ID]
, [STARTED_DATE]
, [COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [FORM_RESPONSE_QUESTION_ID]
, [FORM_RESPONSE_ID]
, [STD_FORM_QUESTION_ID]
, [REGISTRANT_DEPLOYMENT_ID]
, [STARTED_DATE]
, [COMPLETED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_ANSWER_H]...';


GO
Create trigger [AHOBPR].[TRG_FORM_RESPONSE_ANSWER_H] on [AHOBPR].[FORM_RESPONSE_ANSWER]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[FORM_RESPONSE_ANSWER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_ANSWER_ID]
, [FORM_RESPONSE_QUESTION_ID]
, [STD_FORM_ANSWER_ID]
, [ANSWER_VALUE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [FORM_RESPONSE_ANSWER_ID]
, [FORM_RESPONSE_QUESTION_ID]
, [STD_FORM_ANSWER_ID]
, [ANSWER_VALUE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_ANSWER_DEL_H]...';


GO
CREATE TRIGGER  [AHOBPR].[TRG_FORM_RESPONSE_ANSWER_DEL_H]
on  [AHOBPR].[FORM_RESPONSE_ANSWER] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[FORM_RESPONSE_ANSWER_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_ANSWER_ID]
, [FORM_RESPONSE_QUESTION_ID]
, [STD_FORM_ANSWER_ID]
, [ANSWER_VALUE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [FORM_RESPONSE_ANSWER_ID]
, [FORM_RESPONSE_QUESTION_ID]
, [STD_FORM_ANSWER_ID]
, [ANSWER_VALUE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_H]...';


GO
Create trigger [AHOBPR].[TRG_FORM_RESPONSE_H] on [AHOBPR].[FORM_RESPONSE]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[FORM_RESPONSE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_ID]
, [REGISTRANT_ID]
, [STD_FORM_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [FORM_RESPONSE_ID]
, [REGISTRANT_ID]
, [STD_FORM_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
PRINT N'Creating [AHOBPR].[TRG_FORM_RESPONSE_DEL_H]...';


GO
CREATE TRIGGER  [AHOBPR].[TRG_FORM_RESPONSE_DEL_H]
on  [AHOBPR].[FORM_RESPONSE] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[FORM_RESPONSE_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [FORM_RESPONSE_ID]
, [REGISTRANT_ID]
, [STD_FORM_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [FORM_RESPONSE_ID]
, [REGISTRANT_ID]
, [STD_FORM_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO
PRINT N'Creating [AHOBPR].[GetStateCodeByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE FUNCTION [AHOBPR].[GetStateCodeByID](
   @stateId varchar(1000)
)
RETURNS varchar(2000)
AS
BEGIN
	declare @result varchar(2000) = '';
	IF ISNULL(@stateId, '') = ''
		BEGIN
			SET @result = 'AK,AR,AZ,CA,CO,CT,DE,FL,GA,HI,IA,ID,IL,IN,KS,KY,LA,MA,MD,ME,MI,MN,MO,MS,MT,NC,ND,NE,NH,NJ,NM,NV,NY,OH,OK,OR,PA,RI,SC,SD,TN,TX,UT,VA,VT,WA,WI,WV,WY';
		END
	ELSE
	  BEGIN
			DECLARE @state varchar(100);

			DECLARE curState CURSOR 
			  FOR
				SELECT POSTALNAME
				FROM dbo.STD_STATE
				WHERE ID IN (SELECT * FROM fncSplit(@stateId, ','));

			OPEN curState;
			FETCH NEXT FROM curState INTO @state;
			WHILE @@FETCH_STATUS = 0  -- Not End of file
			  BEGIN
				  if  @result != ''
					  SET @result = @result + ','
  				
				  SET @result = @result + @state;
  				
				  FETCH NEXT FROM curState INTO @state;			
			  END		
			CLOSE curState;   
			DEALLOCATE curState;    
	  END 
	return @result;
END;
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[GetAppPageId]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO

CREATE FUNCTION [AHOBPR].[GetAppPageId](
   @code varchar(1000)
)
RETURNS INT
AS
BEGIN
	declare @result INT = 0;
	SET @result = (SELECT ID FROM STD_APPPAGE WHERE Code = @code);
	return @result;
END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [dbo].[AddMaxTime]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 2015.01.09
-- Description:	Add 23:59:59 to a date criteria field to ensure an Ending date parameter will include all rows for the last day.
-- =============================================
CREATE FUNCTION [dbo].[AddMaxTime]
(
     @dateIn   DATETIME2(0)
)
RETURNS DATETIME2(0)
AS 
BEGIN    
 
    return CONVERT(DATETIME2(0), CONVERT(varchar(10),@dateIn, 120)+' 23:59:59', 120);
END

--  select dbo.AddMaxTime(GETDATE());
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [dbo].[CleanDate]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 2015.01.09
-- Description:	Convert a VARCHAR date parameter to a vaid date or return NULL if not valid
-- =============================================
CREATE FUNCTION [dbo].[CleanDate]
(
     @inputText   VARCHAR(100) = NULL
)
RETURNS DATETIME2(0)
AS 
BEGIN    

  DECLARE @returnDate DATETIME2(0) = NULL;
  
  SET @inputText = ISNULL(@inputText,'');
 
  IF ISDATE(@inputText) = 1 
    IF PATINDEX ( '%/%' , @inputText ) > 1
      SET @returnDate = CONVERT(DATETIME2(0),@inputText, 101);
    ELSE
      SET @returnDate = CONVERT(DATETIME2(0),@inputText, 120);
  
    return @returnDate;
END

--  select dbo.CleanDate('09/11/2014');
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [dbo].[MixedCase]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 2015.01.09
-- Description:	Return VARCHAR field as upper case for first Character and lower for the remaining characters
-- =============================================
CREATE FUNCTION [dbo].[MixedCase]
(
     @inputText   VARCHAR(100) = NULL
)
RETURNS VARCHAR(100)
AS 
BEGIN    

  DECLARE @returnText VARCHAR(100) = ''
  
  SET @inputText = ISNULL(@inputText,'');
 
  IF LEN(@inputText) = 1   
     SET @returnText = UPPER(@inputText)
  ELSE
  IF LEN(@inputText) > 1   
     SET @returnText = RTRIM(UPPER(SUBSTRING(@inputText,1,1)) + LOWER(SUBSTRING(@inputText,2,99)));
  
    return @returnText;
END

--  select dbo.MixedCase('bruce');
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[VIEW_FORM]...';


GO


CREATE VIEW [AHOBPR].[VIEW_FORM] AS 
SELECT AHOBPR.STD_FORM.STD_FORM_ID, AHOBPR.STD_FORM.NAME, AHOBPR.STD_FORM.VERSION, AHOBPR.STD_FORM.TITLE, 
	AHOBPR.STD_FORM_SECTION.STD_FORM_SECTION_ID, AHOBPR.STD_FORM_SECTION.TITLE AS SECTION, 
	AHOBPR.STD_FORM_SUB_SECTION.STD_FORM_SUB_SECTION_ID, AHOBPR.STD_FORM_SUB_SECTION.title AS SUBSECTION_TITLE, 
	AHOBPR.STD_FORM_SUB_SECTION.introduction AS SUBSECTION_INTRODUCTION, 
	AHOBPR.STD_FORM_QUESTION.STD_FORM_QUESTION_ID, AHOBPR.STD_FORM_QUESTION.TEXT, 
	AHOBPR.STD_FORM_QUESTION.TYPE, AHOBPR.STD_FORM_QUESTION.MIN, AHOBPR.STD_FORM_QUESTION.MAX, AHOBPR.STD_FORM_QUESTION.MAX_CHOICES,
	AHOBPR.STD_FORM_ANSWER.STD_FORM_ANSWER_ID, AHOBPR.STD_FORM_ANSWER.[ORDER], AHOBPR.STD_FORM_ANSWER.TEXT AS ANSWER_TEXT, 
	AHOBPR.STD_FORM_ANSWER.HELP, AHOBPR.STD_FORM_SECTION.BRP_FORM_SECTION_ID, AHOBPR.STD_FORM_SUB_SECTION.BRP_FORM_SUB_SECTION_ID, 
	AHOBPR.STD_FORM_QUESTION.BRP_FORM_QUESTION_ID, AHOBPR.STD_FORM_ANSWER.BRP_FORM_ANSWER_ID 
FROM AHOBPR.STD_FORM, AHOBPR.STD_FORM_SECTION,  AHOBPR.STD_FORM_SUB_SECTION, AHOBPR.STD_FORM_QUESTION, AHOBPR.STD_FORM_ANSWER
WHERE AHOBPR.STD_FORM.STD_FORM_ID = AHOBPR.STD_FORM_SECTION.STD_FORM_ID 
	  AND AHOBPR.STD_FORM_SECTION.STD_FORM_SECTION_ID = AHOBPR.STD_FORM_SUB_SECTION.STD_FORM_SECTION_ID 
	  AND AHOBPR.STD_FORM_SUB_SECTION.STD_FORM_SUB_SECTION_ID = AHOBPR.STD_FORM_QUESTION.STD_FORM_SUB_SECTION_ID
	  AND AHOBPR.STD_FORM_QUESTION.STD_FORM_QUESTION_ID = AHOBPR.STD_FORM_ANSWER.STD_FORM_QUESTION_ID
GO
PRINT N'Creating [AHOBPR].[VIEW_REGISTRANTS]...';


GO
CREATE VIEW [AHOBPR].[VIEW_REGISTRANTS] AS
/********************************************************************** 
***********************************************************************/
WITH addr AS
(
   SELECT * 
     FROM AHOBPR.REGISTRANT_ADDRESS 
    WHERE TYPE = 'HOME'
)
SELECT reg.REGISTRANT_ID,
       reg.LAST_NAME + ', ' + reg.FIRST_NAME + ' ' + reg.MIDDLE_NAME AS FULL_NAME,
       reg.BIRTH_DATE,
       DATEDIFF(YEAR, reg.BIRTH_DATE, GETDATE()) AS REGISTRANT_AGE,
       reg.GENDER,
       reg.STD_SERVICE_STATUS_ID,
       reg.STD_REGISTRANT_STATUS_ID,
       reg.STD_INSTITUTION_ID,
       ISNULL(reg.REGISTRANT_STATUS_LAST_UPDATED_DATE, reg.UPDATED) AS STATUS_LAST_UPDATED_DATE,
       DATEDIFF(DAY, ISNULL(reg.REGISTRANT_STATUS_LAST_UPDATED_DATE, reg.UPDATED), GETDATE()) As DAYS_AT_CURRENT_STATUS,
       info.EDIPI_MISMATCHED_FLAG,
       info.EDIPI_VERIFIED_DATE,
       info.EULA_ACCEPTED_DATE,
       info.CONTACT_INFO_VERIFIED_DATE,
       addr.COUNTRY,
       addr.STATE,
       addr.CITY
  FROM AHOBPR.REGISTRANT reg
   LEFT JOIN AHOBPR.[REGISTRANT_RECORD_INFO] info
          ON info.REGISTRANT_ID = reg.REGISTRANT_ID
   LEFT JOIN AHOBPR.REGISTRANT_CONTACT_INFO cont
          ON cont.REGISTRANT_ID = info.REGISTRANT_ID
   LEFT JOIN addr
          ON addr.REGISTRANT_ID = cont.REGISTRANT_ID;
    
   
    -- SELECT * FROM [AHOBPR].[VIEW_REGISTRANTS]
GO
PRINT N'Creating [AHOBPR].[VIEW_INSTITUTION]...';


GO
CREATE VIEW [AHOBPR].[VIEW_INSTITUTION]
AS
       SELECT  dbo.STD_INSTITUTION.ID, 
               dbo.STD_INSTITUTION.NAME,
               dbo.STD_INSTITUTION.STATIONNUMBER, 
               dbo.STD_INSTITUTION.VISTANAME, 
               dbo.STD_INSTITUTION.AGENCY_ID,
               dbo.STD_FACILITYTYPE.NAME AS FACILITY_TYPE,
               dbo.STD_INSTITUTION.MFN_ZEG_RECIPIENT, 
               dbo.STD_INSTITUTION.PARENT_ID, 
               dbo.STD_INSTITUTION.REALIGNEDFROM_ID, 
               dbo.STD_INSTITUTION.REALIGNEDTO_ID, 
               dbo.STD_INSTITUTION.VISN_ID, 
               dbo.STD_INSTITUTION.IS_ACTIVE, 
               dbo.STD_INSTITUTION.STREETADDRESSLINE1,  
               dbo.STD_INSTITUTION.STREETCITY, 
               dbo.STD_INSTITUTION.STREETPOSTALCODE, 
               dbo.STD_COUNTRY.SHORTNAME AS COUNTRY_NAME, 
               dbo.STD_COUNTRY.ALPHA3CODE AS COUNTRY_CODE, 
               dbo.STD_STATE.FIPSCODE AS STATE_CODE, 
               dbo.STD_STATE.NAME AS STATE_NAME, 
               dbo.STD_COUNTY.NAME AS COUNTY_NAME, 
               dbo.STD_COUNTY.COUNTYNUMBER, 
               dbo.STD_COUNTY.DESCRIPTION_TEXT AS COUNTY_DESC
         FROM  dbo.STD_INSTITUTION 
         JOIN  dbo.STD_FACILITYTYPE 
           ON  dbo.STD_INSTITUTION.STD_FACILITYTYPE_ID = dbo.STD_FACILITYTYPE.ID 
    LEFT JOIN  dbo.STD_COUNTY 
           ON  dbo.STD_INSTITUTION.STREETCOUNTY_ID = dbo.STD_COUNTY.ID 
    LEFT JOIN  dbo.STD_COUNTRY 
           ON  dbo.STD_INSTITUTION.STREETCOUNTRY_ID = dbo.STD_COUNTRY.ID 
    LEFT JOIN  dbo.STD_STATE 
           ON  dbo.STD_INSTITUTION.STREETSTATE_ID = dbo.STD_STATE.ID;
          
-- SELECT * FROM [AHOBPR].[VIEW_INSTITUTION]         
GO
PRINT N'Creating [AHOBPR].[VIEW_US_LOCATIONS]...';


GO
CREATE VIEW [AHOBPR].[VIEW_US_LOCATIONS]
AS
  SELECT STD_COUNTRY.ID AS COUNTRY_ID,
         STD_COUNTRY.ALPHA3CODE AS COUNTRY_CODE,
         STD_COUNTRY.POSTALNAME AS COUNTRY_NAME,
         STD_STATE.ID AS STATE_ID,
         STD_STATE.POSTALNAME AS STATE_CODE,
         STD_STATE.NAME AS STATE_NAME,
         STD_COUNTY.ID AS COUNTY_ID,
         STD_COUNTY.NAME AS COUNTY_NAME       
    FROM dbo.STD_COUNTY
    JOIN dbo.STD_STATE
      ON STD_STATE.ID = STD_COUNTY.STATE_ID
    JOIN dbo.STD_COUNTRY
      ON STD_COUNTRY.ID = STD_STATE.COUNTRY_ID;
GO
PRINT N'Creating [AHOBPR].[VIEW_LOOKUP]...';


GO
CREATE VIEW [AHOBPR].[VIEW_LOOKUP] WITH SCHEMABINDING AS
SELECT 'REGISTRY_FLAG' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
UNION ALL
SELECT 'REGISTRY_STATUS' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
UNION ALL
SELECT 'REGISTRY_FLAG_TYPE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_TYPE_ID AS ID
       ,REGISTRY_FLAG_TYPE AS CODE
       ,REGISTRY_FLAG_TYPE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG_TYPE
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1 AND STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,ID 
       ,POSTALNAME AS CODE
       ,POSTALNAME NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM DBO.STD_STATE
WHERE COUNTRY_ID = 1006840
	  AND POSTALNAME IN ('AL', 'AK', 'AR', 'AZ', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 
	  'IA', 'ID', 'IL', 'IN', 'KS', 'KY', 'LA', 'MA', 'MD', 'ME', 'MI', 'MN', 'MO', 'MS', 
	  'MT', 'NC', 'ND', 'NE', 'NH', 'NJ', 'NM', 'NV', 'NY', 'OH', 'OK', 'OR', 'PA', 'RI', 
	  'SC', 'SD', 'TN', 'TX', 'UT', 'VA', 'VT', 'WA', 'WI', 'WV', 'WY') 
UNION ALL
SELECT 'ADMINTRACKING_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1 AND STD_REGISTRY_FLAG_TYPE_ID = 1 AND PREDEFINED = 0
UNION ALL
SELECT 'STD_SERVICE_STATUS' AS LOOKUP_TYPE  
	   ,STD_SERVICE_STATUS_ID As ID
       ,SERVICE_STATUS AS CODE
       ,SERVICE_STATUS AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_SERVICE_STATUS
  UNION ALL
SELECT 'STD_FORM_QUESTION' AS LOOKUP_TYPE  
	   ,STD_FORM_QUESTION_ID As ID
       ,FORM_QUESTION_UNIQUE_ID AS CODE
       ,FORM_QUESTION_UNIQUE_ID AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM_QUESTION
UNION ALL
SELECT 'REGISTRY_STATUS_INELIGIBLE' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (3, 4, 5)
UNION ALL
SELECT 'REGISTRY_STATUS_REVIEWED' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (5, 6)
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	   ,1 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	   ,2 AS ID
       ,'Facility' AS CODE
       ,'Facility' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	   ,3 AS ID
       ,'VISN' AS CODE
       ,'VISN' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ALL' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'ADMIN_FLAG_ALL' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 1
UNION ALL
SELECT 'HEALTH_FACTOR' AS LOOKUP_TYPE
	   ,A.[STD_HEALTH_FACTOR_ID] AS ID
       ,A.[NAME] AS CODE
       ,B.[DESCRIPTION] + ': ' + A.DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_HEALTH_FACTOR] A INNER JOIN [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] B ON A.STD_HEALTH_FACTOR_CATEGORY_ID = B.STD_HEALTH_FACTOR_CATEGORY_ID
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY' AS LOOKUP_TYPE
	   ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT]
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY_EXPOSURE' AS LOOKUP_TYPE
	   ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] A JOIN AHOBPR.FORM_RESPONSE_QUESTION B
	ON A.REGISTRANT_DEPLOYMENT_ID = B.REGISTRANT_DEPLOYMENT_ID
GO
PRINT N'Creating [AHOBPR].[VIEW_HEALTH_FACTOR]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
CREATE VIEW [AHOBPR].[VIEW_HEALTH_FACTOR] WITH SCHEMABINDING AS
SELECT A.REGISTRANT_HEALTH_FACTOR_ID, A.REGISTRANT_EVALUATION_ID, D.REGISTRANT_ID, D.EVALUATION_DATE_TIME, B.DESCRIPTION AS HEALTH_FACTOR, 
	C.DESCRIPTION AS HEALTH_FACTOR_CATEGORY, c.TOOLTIP as CATEGORY_TOOLTIP, B.SORT_ORDER AS SORT_ORDER, B.STD_HEALTH_FACTOR_CATEGORY_ID
  FROM [AHOBPR].[REGISTRANT_HEALTH_FACTOR] A, AHOBPR.STD_HEALTH_FACTOR B, AHOBPR.STD_HEALTH_FACTOR_CATEGORY C,
	AHOBPR.REGISTRANT_EVALUATION D
  WHERE A.STD_HEALTH_FACTOR_ID = B.STD_HEALTH_FACTOR_ID 
	AND B.STD_HEALTH_FACTOR_CATEGORY_ID = C.STD_HEALTH_FACTOR_CATEGORY_ID
	AND A.REGISTRANT_EVALUATION_ID = D.REGISTRANT_EVALUATION_ID
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[ERROR_LOG_Log]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Dave May
-- Create date: 22 July 2012
-- Description:	Used to log errors to the ERROR_LOG table.
-- =============================================
CREATE PROCEDURE AHOBPR.ERROR_LOG_Log
	@ErrorProcedure nvarchar(128),
	@ErrorMessage nvarchar(4000) 
AS
BEGIN
  SET NOCOUNT ON;
  SET IMPLICIT_TRANSACTIONS OFF ;

  DECLARE @User varchar(255) = ORIGINAL_LOGIN();
  DECLARE @Now datetime2(0) = GETDATE();
  
  INSERT 
    INTO [AHOBPR].[ERROR_LOG]
         ([COMPONENT_TYPE]
         ,[ERROR_TYPE]
         ,[ERROR_SOURCE]
         ,[ERROR_MESSAGE]
         ,[CREATEDBY]
         ,[UPDATEDBY]
         ,[UPDATED]
          )
    VALUES
		       ('Database', 
		        'Stored Procedure',
			      @ErrorProcedure,
			      @ErrorMessage,
			      @User,
			      @User,
			      @Now
			     );
      
  RETURN SCOPE_IDENTITY();
END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportGetStatusByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Sherry Wang
-- Create date: December 01, 2014
-- Description:	Used for the AHOBPR Status by Location Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetStatusByID]
       @statusId varchar(100) = NULL -- Multiple statues, comma-separated values when not NULL 
       
AS
BEGIN
  DECLARE @statusDescription varchar(4000) = ''
  DECLARE @status varchar(100)
	
  DECLARE curStatus CURSOR 
      FOR
        SELECT REGISTRANT_STATUS
		FROM AHOBPR.STD_REGISTRANT_STATUS
		WHERE STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@statusId, ','))
			OR ISNULL(@statusId, '') = '';

  OPEN curStatus;
  FETCH NEXT FROM curStatus INTO @status;
  WHILE @@FETCH_STATUS = 0  -- Not End of file
	BEGIN
		if  @statusDescription != ''
			SET @statusDescription = @statusDescription + ', '
		
		SET @statusDescription = @statusDescription + @status;
		FETCH NEXT FROM curStatus INTO @status;			
	END		
  CLOSE curStatus;   
  DEALLOCATE curStatus;    
  
  SELECT  @statusDescription AS STATUS_DESCRIPTION 

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportGetStateByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Sherry Wang
-- Create date: December 01, 2014
-- Description:	Used for the AHOBPR Status by Location Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetStateByID]
       @stateId varchar(1000) = NULL -- Multiple statues, comma-separated values when not NULL 
       
AS
BEGIN
  SELECT  AHOBPR.GetStateCodeByID (@stateId) AS STATE_DESCRIPTION 
END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportGetFacilityNameByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Sherry Wang
-- Create date: January 07, 2015
-- Description:	Used for the AHOBPR Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetFacilityNameByID]
       @InstitutionId VARCHAR(50) = '0' 
       
AS
BEGIN  
	  SELECT  Name
	  FROM dbo.viewFacilitiesByVisn
	  WHERE institution_id = @InstitutionId

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportGetAnswerByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: 1/9/2015
-- Description:	Used for the AHOBPR Ad Hoc Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetAnswerByID]
       @answerId varchar(100) = NULL -- Multiple statues, comma-separated values when not NULL 
       
AS
BEGIN
  DECLARE @answerDescription varchar(4000) = ''
  DECLARE @answer varchar(100)
	
  DECLARE curAnswer CURSOR 
      FOR
        SELECT TEXT
		FROM AHOBPR.STD_FORM_ANSWER
		WHERE STD_FORM_ANSWER_ID IN (SELECT * FROM fncSplit(@answerId, ','))
			OR ISNULL(@answerId, '') = '';

  OPEN curAnswer;
  FETCH NEXT FROM curAnswer INTO @answer;
  WHILE @@FETCH_STATUS = 0  -- Not End of file
	BEGIN
		if  @answerDescription != ''
			SET @answerDescription = @answerDescription + ', '
		
		SET @answerDescription = @answerDescription + @answer;
		FETCH NEXT FROM curAnswer INTO @answer;			
	END		
  CLOSE curAnswer;   
  DEALLOCATE curAnswer;    
  
  SELECT  @answerDescription AS ANSWER_DESCRIPTION 

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportGetQuestionByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: 1/9/2015
-- Description:	Used for the AHOBPR Ad Hoc Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetQuestionByID]
       @QuestionUniqueId varchar(100) = NULL
       
AS
BEGIN  
	  --SELECT  {fn concat(FORM_QUESTION_UNIQUE_ID, TEXT)} AS QUESTION_DESCRIPTION
	  SELECT  FORM_QUESTION_UNIQUE_ID + '  ' + TEXT AS QuestionDescription 
	  FROM AHOBPR.STD_FORM_QUESTION
	  WHERE FORM_QUESTION_UNIQUE_ID = @QuestionUniqueId

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportGetDutyStatusByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO

-- =============================================
-- Author:		Deborah Barr
-- Create date: December 08, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetDutyStatusByID]
       @dutyStatusId varchar(100) = NULL -- Multiple statues, comma-separated values when not NULL 
       
AS
BEGIN
  DECLARE @dutyStatusDescription varchar(4000) = ''
  DECLARE @dutyStatus varchar(100)
	
  DECLARE curDutyStatus CURSOR 
      FOR
        SELECT SERVICE_STATUS
		FROM AHOBPR.STD_SERVICE_STATUS
		WHERE STD_SERVICE_STATUS_ID IN (SELECT * FROM fncSplit(@dutyStatusId, ','))
			OR ISNULL(@dutyStatusId, '') = '';

  OPEN curDutyStatus;
  FETCH NEXT FROM curDutyStatus INTO @dutyStatus;
  WHILE @@FETCH_STATUS = 0  -- Not End of file
	BEGIN
		if  @dutyStatusDescription != ''
			SET @dutyStatusDescription = @dutyStatusDescription + ', '
		
		SET @dutyStatusDescription = @dutyStatusDescription + @dutyStatus;
		FETCH NEXT FROM curDutyStatus INTO @dutyStatus;			
	END		
  CLOSE curDutyStatus;   
  DEALLOCATE curDutyStatus;    
  
  SELECT  @dutyStatusDescription AS DUTY_STATUS_DESCRIPTION 

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportGetFlagNameByID]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO


-- =============================================
-- Author:		Deborah Barr
-- Create date: 1/9/2015
-- Description:	Used for the AHOBPR Ad Hoc Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetFlagNameByID]
       @FlagId INT = 0 
       
AS
BEGIN  
	  SELECT  REGISTRY_FLAG_NAME
	  FROM AHOBPR.STD_REGISTRY_FLAG
	  WHERE STD_REGISTRY_FLAG_ID = @FlagId

END
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportEligibility]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 01/20/2015
-- Description:	Used for the AHOBPR Eligibility Report  

-- Modification log

-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportEligibility]
       @status varchar(1000) = NULL, -- Multiple statues, comma-separated values when not NULL
       @adminFlag varchar (10) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL;
    
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE()));                         

    SELECT a.REGISTRANT_ID
		   ,a.SSN
           ,a.LAST_NAME 
           ,a.FIRST_NAME 
           ,a.MIDDLE_NAME
	  FROM AHOBPR.REGISTRANT a
	 WHERE (a.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@status, ','))OR ISNULL(@status,'') = '')   
	   AND ((ISNULL(@adminFlag,'') = '')
 	         OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag
                      WHERE adminflag.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@adminFlag, ','))
                        AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID
                        AND adminflag.CREATED BETWEEN @adminFlagFromDate AND @adminFlagToDate)); 			

END

-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportEligibility] 
-- EXECUTE [AHOBPR].[SP_ReportEligibility] @adminFlag = '59,60'
-- EXECUTE [AHOBPR].[SP_ReportEligibility] @status = '1,2,3,4'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportParticipantDetails]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Jan 5, 2015
-- Description:	Used for the AHOBPR Participation Report Drilldown  -- exec [AHOBPR].[SP_ReportParticipantDetails]    (More options at bottom)
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportParticipantDetails]
       @StartDate DATETIME2(0) = NULL,  
       @EndDate DATETIME2(0) = NULL,
       @RegistrantStatus  VARCHAR(50) = '',  -- 'Participant', 'Review - Not Eligible', 'Eligible', 'No Consent', 'Consent', 'Review'
       @SvcStatus  VARCHAR(50) = '',         -- 'Veteran', 'Retiree', 'Active Duty'
       @RequestSeen  VARCHAR(50) = '',       -- 'Yes', 'No', 'Unknown'
       @HealthConcern  VARCHAR(50) = '',     -- 'Yes', 'No'
       @DeploymentGroup VARCHAR(50) = '',    -- 'Afgh911', 'Iraq911', 'SouthwestAsiaAfter911', 'Pre911',  'DjiboutiAfter911'
       @InstitutionId INT = 0,               -- 1000109,  1000089
       @VisnId VARCHAR(50) = ''              -- 'V16', 'V01'
AS
BEGIN

  SET @StartDate = ISNULL(@StartDate,'19900802');
  SET @EndDate = ISNULL(@EndDate, GetDate());
  SET @EndDate = dbo.AddMaxTime(@EndDate);  -- Adds 23:59:59 to criteria parameter
  
  DECLARE @911Date DATETIME2(0) = '20010911',
          @DesertStormDate DATETIME2(0) = '19900802';

  --Temp table for Deployments
  CREATE TABLE #Deployments
  (
	   [REGISTRANT_ID] INT
  ); 
  
  IF @DeploymentGroup = 'Afgh911'    
    INSERT INTO #Deployments([REGISTRANT_ID])
    SELECT DISTINCT deployment.REGISTRANT_ID
      FROM AHOBPR.REGISTRANT_DEPLOYMENT deployment 
      JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure
        ON deployment.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID
      JOIN AHOBPR.STD_FORM_QUESTION quest
        ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID
     WHERE quest.FORM_QUESTION_UNIQUE_ID = '1.2.A'
       AND [DEPLOYMENT_COUNTRY] = 'Afghanistan' 
       AND [DEPLOYMENT_START_DATE] > @911Date
  ELSE
  IF @DeploymentGroup = 'Iraq911'
    INSERT INTO #Deployments([REGISTRANT_ID])
    SELECT DISTINCT deployment.REGISTRANT_ID
      FROM AHOBPR.REGISTRANT_DEPLOYMENT deployment 
      JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure
        ON deployment.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID
      JOIN AHOBPR.STD_FORM_QUESTION quest
        ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID
     WHERE quest.FORM_QUESTION_UNIQUE_ID = '1.2.A'
       AND [DEPLOYMENT_COUNTRY] = 'Iraq' 
       AND [DEPLOYMENT_START_DATE] > @911Date 
  ELSE
  IF @DeploymentGroup = 'DjiboutiAfter911'
    INSERT INTO #Deployments([REGISTRANT_ID])
    SELECT DISTINCT deployment.REGISTRANT_ID
      FROM AHOBPR.REGISTRANT_DEPLOYMENT deployment 
      JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure
        ON deployment.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID
      JOIN AHOBPR.STD_FORM_QUESTION quest
        ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID
     WHERE quest.FORM_QUESTION_UNIQUE_ID = '1.2.A'
       AND [DEPLOYMENT_COUNTRY] = 'Djibouti' 
       AND [DEPLOYMENT_START_DATE] > @911Date 
  ELSE
  IF @DeploymentGroup = 'SouthwestAsiaAfter911'
    INSERT INTO #Deployments([REGISTRANT_ID])
    SELECT DISTINCT deployment.REGISTRANT_ID
      FROM AHOBPR.REGISTRANT_DEPLOYMENT deployment 
      JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure
        ON deployment.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID
      JOIN AHOBPR.STD_FORM_QUESTION quest
        ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID
     WHERE quest.FORM_QUESTION_UNIQUE_ID = '1.2.A'
       AND [DEPLOYMENT_COUNTRY] IN ('Kuwait','Saudi Arabia','Bahrain', 'Gulf of Aden', 'Gulf of Oman', 'Oman', 'Qatar', 'United Arab Emirates', 'Persian Gulf', 'Arabian Sea', 'Red Sea') 
       AND [DEPLOYMENT_START_DATE] > @911Date 
  ELSE
  IF @DeploymentGroup = 'Pre911'
    INSERT INTO #Deployments([REGISTRANT_ID])
    SELECT DISTINCT deployment.REGISTRANT_ID
      FROM AHOBPR.REGISTRANT_DEPLOYMENT deployment 
      JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure
        ON deployment.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID
      JOIN AHOBPR.STD_FORM_QUESTION quest
        ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID
     WHERE quest.FORM_QUESTION_UNIQUE_ID = '1.2.A'
       AND [DEPLOYMENT_START_DATE] BETWEEN @DesertStormDate AND @911Date  
       AND [DEPLOYMENT_COUNTRY] IN ('Iraq','Kuwait','Saudi Arabia','Bahrain', 'Gulf of Aden', 'Gulf of Oman', 'Oman', 'Qatar', 'United Arab Emirates', 'Persian Gulf', 'Arabian Sea', 'Red Sea');       
        
    WITH eligible 
      AS ( 
          SELECT [REGISTRANT_ID],MIN([CREATED]) AS DateEligible
            FROM [AHOBPR].[PROCESS_METRICS]
           WHERE [PROCESS_METRICS_VALUE] = 'Eligible'
           GROUP BY [REGISTRANT_ID]
         ),
      participant 
      AS (
         SELECT [REGISTRANT_ID], MAX([CREATED]) AS DateParticipant
           FROM [AHOBPR].[PROCESS_METRICS]
          WHERE [PROCESS_METRICS_VALUE] = 'Participant'   
          GROUP BY [REGISTRANT_ID]
          )        
  	SELECT reg.REGISTRANT_ID
		     ,(reg.LAST_NAME + ', ' + reg.FIRST_NAME) AS Name
		     ,stat.REGISTRANT_STATUS
		     ,svc.SERVICE_STATUS
		     ,QUESTIONNAIRE_COMPLETED_DATE
		     ,ISNULL(reg.REQUEST_SEEN_RESPONSE, 'Unknown') AS REQUEST_SEEN_RESPONSE
		     ,ISNULL(reg.HEALTH_CONCERNS_RESPONSE,'No') AS HEALTH_CONCERNS_RESPONSE
		     ,ISNULL(inst.Name,'') AS InstitutionName
		     ,CONVERT(VARCHAR(10), responseStat.QUESTIONNAIRE_COMPLETED_DATE, 101) AS QUESTIONNAIRE_COMPLETED_Display
		     ,CASE WHEN DateParticipant > DateEligible THEN DATEDIFF(Day,DateEligible,DateParticipant) ELSE 0 END AS DaysEligibleToParticipant
         ,reg.BIRTH_DATE AS BirthDate
         ,CONVERT(VARCHAR(10), reg.BIRTH_DATE, 101) AS BirthDateDisplay
	  FROM AHOBPR.REGISTRANT reg
		JOIN AHOBPR.STD_REGISTRANT_STATUS stat 
		  ON reg.STD_REGISTRANT_STATUS_ID = stat.STD_REGISTRANT_STATUS_ID
		JOIN AHOBPR.STD_SERVICE_STATUS svc
		  ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID
		JOIN AHOBPR.FORM_RESPONSE resp 
		  ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
		JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
		  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID
    JOIN eligible 
      ON reg.REGISTRANT_ID = eligible.REGISTRANT_ID
    JOIN participant 
      ON reg.REGISTRANT_ID = participant.REGISTRANT_ID   		  
		LEFT JOIN dbo.viewFacilitiesByVisn inst
		  ON inst.institution_id = reg.STD_INSTITUTION_ID
 	 WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @StartDate AND @EndDate
	   AND (stat.REGISTRANT_STATUS = @RegistrantStatus
	        OR ISNULL(@RegistrantStatus,'') = '')
	   AND (svc.SERVICE_STATUS = @SvcStatus
	        OR ISNULL(@SvcStatus,'') = '')	
	   AND (ISNULL(reg.HEALTH_CONCERNS_RESPONSE,'No') = @HealthConcern     
	        OR ISNULL(@HealthConcern,'') = '')
     AND (ISNULL(reg.REQUEST_SEEN_RESPONSE, 'Unknown') =  @RequestSeen
          OR ISNULL(@RequestSeen,'') = '') 
     AND (EXISTS(SELECT * FROM #Deployments WHERE #Deployments.REGISTRANT_ID = reg.REGISTRANT_ID)
          OR ISNULL(@DeploymentGroup,'') = '')
     AND (reg.STD_INSTITUTION_ID =  @InstitutionId
          OR ISNULL(@InstitutionId,0) = 0) 
     AND (inst.VisnID =  @VisnID
          OR ISNULL(@VisnID,'') = '') 
     ORDER BY responseStat.QUESTIONNAIRE_COMPLETED_DATE
          ;
      
  DROP TABLE #Deployments;                                                                                                       
END

-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] '20140810', '20141113', NULL, NULL, NULL, NULL, NULL, NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, 'Participant', NULL, NULL, NULL, NULL, NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, 'Veteran', NULL, NULL, NULL, NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, 'Yes', NULL, NULL, NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, 'No', NULL, NULL, NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, 'Unknown', NULL, NULL, NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, 'Yes', NULL, NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, 'No', NULL, NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'Afgh911', NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'Iraq911', NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'SouthwestAsiaAfter911', NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'DjiboutiAfter911', NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'Pre911', NULL, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1000109, NULL
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'V16'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportParticipation]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Dec 30, 2014
-- Description:	Used for the AHOBPR Participation Report       -- exec [AHOBPR].[SP_ReportParticipation] 
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportParticipation]
       @StartDate DATETIME2(0) = NULL,  
       @EndDate DATETIME2(0) = NULL,
       @InstitutionId INT = 0,        -- 1000109,  1000089
       @VisnId VARCHAR(50) = ''       -- 'V16', 'V01'
AS
BEGIN

  SET @StartDate = ISNULL(@StartDate,'19900802');
  SET @EndDate = ISNULL(@EndDate, GetDate());
  
  DECLARE @911Date DATETIME2(0) = '20010911',
          @DesertStormDate DATETIME2(0) = '19900802';
  
  DECLARE @ConsentStatusCount INT = 0,
          @EligibleStatusCount INT = 0,
          @ParticipantStatusCount INT = 0,
          @HealthConcernsCount INT = 0,
          @NoHealthConcernsCount INT = 0,
          @RequestSeenCount INT = 0,
          @NoRequestSeenCount INT = 0,
          @DoNotKnowRequestSeenCount INT = 0,
          @VeteranServiceStatusCount INT = 0,
          @ActiveDutyServiceStatusCount INT = 0,
          @RetireeServiceStatusCount INT = 0,
          @Afgh911Count INT = 0,
          @Iraq911Count INT = 0,
          @SWA911Count INT = 0,
          @Pre911Count INT = 0,
          @Djibouti911Count INT = 0,
          @MedianDaysToParticipant DECIMAL(9,2) = 0;
          
  DECLARE @NoInstitutionFilter BIT = 0;          
          
  CREATE TABLE #Institutions
  (
	   [InstitutionID] INT
  )             
          
      IF @InstitutionId > 0 
         INSERT INTO #Institutions([InstitutionID])
             VALUES(@InstitutionId)
      ELSE
      IF LEN(@VisnId) > 0  
         INSERT INTO #Institutions([InstitutionID])
             SELECT inst.institution_id 
               FROM dbo.viewFacilitiesByVisn inst
              WHERE VisnID = @VisnId
      ELSE
        SET @NoInstitutionFilter = 1;

      SELECT @ParticipantStatusCount = COUNT(*) 
        FROM [AHOBPR].[REGISTRANT] reg
        JOIN AHOBPR.STD_REGISTRANT_STATUS stat
          ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID 
        JOIN AHOBPR.FORM_RESPONSE resp 
          ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
          ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID          
       WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @StartDate AND @EndDate
         AND ( EXISTS(SELECT [InstitutionID] FROM #Institutions WHERE [InstitutionID] = reg.STD_INSTITUTION_ID)  
              OR @NoInstitutionFilter = 1)
         AND stat.REGISTRANT_STATUS = 'Participant'; 
                           
      SELECT @HealthConcernsCount = COUNT(*) 
        FROM [AHOBPR].[REGISTRANT] reg
        JOIN AHOBPR.FORM_RESPONSE resp 
          ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
          ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID          
       WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @StartDate AND @EndDate
         AND ( EXISTS(SELECT [InstitutionID] FROM #Institutions WHERE [InstitutionID] = reg.STD_INSTITUTION_ID)  
              OR @NoInstitutionFilter = 1)
         AND reg.HEALTH_CONCERNS_RESPONSE = 'Yes';   
                                  
      SELECT @NoHealthConcernsCount = COUNT(*) 
        FROM [AHOBPR].[REGISTRANT] reg
        JOIN AHOBPR.FORM_RESPONSE resp 
          ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
          ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID          
       WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @StartDate AND @EndDate
         AND ( EXISTS(SELECT [InstitutionID] FROM #Institutions WHERE [InstitutionID] = reg.STD_INSTITUTION_ID)  
              OR @NoInstitutionFilter = 1)
         AND reg.HEALTH_CONCERNS_RESPONSE IS NULL;       

      SELECT @RequestSeenCount = COUNT(*) 
        FROM [AHOBPR].[REGISTRANT] reg
        JOIN AHOBPR.FORM_RESPONSE resp 
          ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
          ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID          
       WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @StartDate AND @EndDate
         AND ( EXISTS(SELECT [InstitutionID] FROM #Institutions WHERE [InstitutionID] = reg.STD_INSTITUTION_ID)  
              OR @NoInstitutionFilter = 1)
         AND reg.REQUEST_SEEN_RESPONSE = 'Yes';   
                                  
      SELECT @NoRequestSeenCount = COUNT(*) 
        FROM [AHOBPR].[REGISTRANT] reg
        JOIN AHOBPR.FORM_RESPONSE resp 
          ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
          ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID          
       WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @StartDate AND @EndDate
         AND ( EXISTS(SELECT [InstitutionID] FROM #Institutions WHERE [InstitutionID] = reg.STD_INSTITUTION_ID)  
              OR @NoInstitutionFilter = 1)
         AND reg.REQUEST_SEEN_RESPONSE = 'No';      
                                  
      SELECT @DoNotKnowRequestSeenCount = COUNT(*) 
        FROM [AHOBPR].[REGISTRANT] reg
        JOIN AHOBPR.FORM_RESPONSE resp 
          ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
          ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID          
       WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @StartDate AND @EndDate
         AND ( EXISTS(SELECT [InstitutionID] FROM #Institutions WHERE [InstitutionID] = reg.STD_INSTITUTION_ID)  
              OR @NoInstitutionFilter = 1)
         AND ISNULL(reg.REQUEST_SEEN_RESPONSE,'') NOT IN ('Yes','No');                           
         
      SELECT @ActiveDutyServiceStatusCount = COUNT(*) 
        FROM [AHOBPR].[REGISTRANT] reg
        JOIN AHOBPR.STD_SERVICE_STATUS svc
          ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID
        JOIN AHOBPR.FORM_RESPONSE resp 
          ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
          ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID          
       WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @StartDate AND @EndDate
         AND ( EXISTS(SELECT [InstitutionID] FROM #Institutions WHERE [InstitutionID] = reg.STD_INSTITUTION_ID)  
              OR @NoInstitutionFilter = 1)
         AND svc.SERVICE_STATUS = 'Active Duty';        
 
      SELECT @VeteranServiceStatusCount = COUNT(*) 
        FROM [AHOBPR].[REGISTRANT] reg
        JOIN AHOBPR.STD_SERVICE_STATUS svc
          ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID
        JOIN AHOBPR.FORM_RESPONSE resp 
          ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
          ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID          
       WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @StartDate AND @EndDate
         AND ( EXISTS(SELECT [InstitutionID] FROM #Institutions WHERE [InstitutionID] = reg.STD_INSTITUTION_ID)  
              OR @NoInstitutionFilter = 1)
         AND svc.SERVICE_STATUS = 'Veteran'; 
                  
      SELECT @RetireeServiceStatusCount = COUNT(*) 
        FROM [AHOBPR].[REGISTRANT] reg
        JOIN AHOBPR.STD_SERVICE_STATUS svc
          ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID
        JOIN AHOBPR.FORM_RESPONSE resp 
          ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
          ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID          
       WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @StartDate AND @EndDate
         AND ( EXISTS(SELECT [InstitutionID] FROM #Institutions WHERE [InstitutionID] = reg.STD_INSTITUTION_ID)  
              OR @NoInstitutionFilter = 1)
         AND svc.SERVICE_STATUS = 'Retiree'; 
                                                         
-- Deployment Counts  
  WITH Deployments
  AS ( 
    SELECT 
        dply.REGISTRANT_ID ,
       --[DEPLOYMENT_COUNTRY],
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] = 'Iraq' 
                           AND [DEPLOYMENT_START_DATE] > @911Date 
                           THEN 1 ELSE 0 END) )> 0 
           THEN 1 ELSE 0 END AS Iraq911Count,
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] = 'Afghanistan'  
                           AND [DEPLOYMENT_START_DATE] > @911Date 
                          THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END AS Afgh911Count,              
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] = 'Djibouti'  
                           AND [DEPLOYMENT_START_DATE] > @911Date 
                          THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END AS Djibouti911Count,              
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] IN ('Kuwait','Saudi Arabia','Bahrain', 'Gulf of Aden', 'Gulf of Oman', 'Oman', 'Qatar', 'United Arab Emirates', 'Persian Gulf', 'Arabian Sea', 'Red Sea')
                           AND [DEPLOYMENT_START_DATE] > @911Date 
                           THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END AS SWA911Count,
      CASE WHEN (SUM(CASE WHEN ([DEPLOYMENT_START_DATE] BETWEEN @DesertStormDate AND @911Date ) 
                           AND  [DEPLOYMENT_COUNTRY] IN ('Iraq','Kuwait','Saudi Arabia','Bahrain', 'Gulf of Aden', 'Gulf of Oman', 'Oman', 'Qatar', 'United Arab Emirates', 'Persian Gulf', 'Arabian Sea', 'Red Sea')
                          THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END  AS Pre911Count
    FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] dply
        JOIN AHOBPR.FORM_RESPONSE resp 
          ON resp.REGISTRANT_ID = dply.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
          ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID   
        JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure
	        ON dply.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID
	      JOIN AHOBPR.STD_FORM_QUESTION quest
	        ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID
	     WHERE quest.FORM_QUESTION_UNIQUE_ID = '1.2.A'                 
       AND responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @StartDate AND @EndDate    
    GROUP BY dply.REGISTRANT_ID 
     )
     SELECT @Afgh911Count =  SUM(ISNULL(Deployments.Afgh911Count,0))  
           ,@Iraq911Count =  SUM(ISNULL(Deployments.Iraq911Count,0))
           ,@SWA911Count = SUM(ISNULL(Deployments.SWA911Count,0))
           ,@Pre911Count =   SUM(ISNULL(Deployments.Pre911Count,0))
           ,@Djibouti911Count = SUM(ISNULL(Deployments.Djibouti911Count,0))
      FROM [AHOBPR].[REGISTRANT] reg
      JOIN Deployments
        ON reg.REGISTRANT_ID = Deployments.REGISTRANT_ID
      JOIN AHOBPR.FORM_RESPONSE resp 
        ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
      JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
        ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID          
     WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @StartDate AND @EndDate         
       AND ( EXISTS(SELECT [InstitutionID] FROM #Institutions WHERE [InstitutionID] = reg.STD_INSTITUTION_ID)  
              OR @NoInstitutionFilter = 1);
  
     CREATE TABLE #DaysToParticipant(DAYS INT);
   
    -- Median Days from Eligible to Participant Status    
    -- Note that only Registrants with Both values and DateParticipant > DateEligible will be counted for either Numerator or Denominator
    WITH eligible 
      AS ( 
          SELECT [REGISTRANT_ID],MIN([CREATED]) AS DateEligible
            FROM [AHOBPR].[PROCESS_METRICS]
           WHERE [PROCESS_METRICS_VALUE] = 'Eligible'
           GROUP BY [REGISTRANT_ID]
         ),
      participant 
      AS (
         SELECT [REGISTRANT_ID],MAX([CREATED]) AS DateParticipant
           FROM [AHOBPR].[PROCESS_METRICS]
          WHERE [PROCESS_METRICS_VALUE] = 'Participant'   
           GROUP BY [REGISTRANT_ID]
          )
     INSERT INTO #DaysToParticipant(DAYS)
    SELECT 
           CASE WHEN DateParticipant > DateEligible THEN DATEDIFF(Day,DateEligible,DateParticipant) ELSE 0 END AS DaysDifference
      FROM [AHOBPR].[REGISTRANT] reg
      JOIN eligible 
        ON reg.REGISTRANT_ID = eligible.REGISTRANT_ID
      JOIN participant 
        ON reg.REGISTRANT_ID = participant.REGISTRANT_ID   
      JOIN AHOBPR.FORM_RESPONSE resp 
        ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
      JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
        ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID          
     WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @StartDate AND @EndDate
       AND ( EXISTS(SELECT [InstitutionID] FROM #Institutions WHERE [InstitutionID] = reg.STD_INSTITUTION_ID)  
             OR @NoInstitutionFilter = 1)    
     ORDER BY DaysDifference;
     
    WITH Counts AS
    (
       SELECT c=COUNT(*)
       FROM #DaysToParticipant
    )
    SELECT @MedianDaysToParticipant = AVG(0. + DAYS)
    FROM Counts a
    CROSS APPLY
    (
       SELECT TOP(((a.c - 1) / 2) + (1 + (1 - a.c % 2)))
          DAYS, r=ROW_NUMBER() OVER (ORDER BY DAYS)
       FROM #DaysToParticipant b
       ORDER BY DAYS
    ) p
    WHERE r BETWEEN ((a.c - 1) / 2) + 1 AND (((a.c - 1) / 2) + (1 + (1 - a.c % 2))); 
         
    DROP  TABLE #DaysToParticipant;
                  
    DROP TABLE #Institutions;                       
 
 -- Return Results
   SELECT ISNULL(@ParticipantStatusCount,0) AS ParticipantStatusCount,
          ISNULL(@HealthConcernsCount,0) AS ReportedHealthConcernsCount,
          ISNULL(@NoHealthConcernsCount,0) AS  NoReportedHealthConcernsCount,
          ISNULL(@RequestSeenCount,0) AS RequestSeenCount,
          ISNULL(@NoRequestSeenCount,0) AS NoRequestSeenCount,
          ISNULL(@DoNotKnowRequestSeenCount,0) AS DoNotKnowRequestSeenCount,
          ISNULL(@VeteranServiceStatusCount,0) AS VeteranServiceStatusCount ,
          ISNULL(@ActiveDutyServiceStatusCount,0) AS  ActiveDutyServiceStatusCount,
          ISNULL(@RetireeServiceStatusCount,0) AS RetireeServiceStatusCount,
          ISNULL(@Afgh911Count,0) AS  Afgh911Count,
          ISNULL(@Iraq911Count,0) AS Iraq911Count,
          ISNULL(@SWA911Count,0) AS  SouthWestAsia911Count,
          ISNULL(@Pre911Count,0) AS  Pre911Count,
          ISNULL(@MedianDaysToParticipant,0.0) AS MedianDaysToParticipant,
          @Djibouti911Count AS Djibouti911Count ;

END

-- exec [AHOBPR].[SP_ReportParticipation] NULL, NULL, 1000109, NULL
-- exec [AHOBPR].[SP_ReportParticipation] NULL, NULL, NULL, 'V01'
-- exec [AHOBPR].[SP_ReportParticipation] NULL, NULL, 1000000, NULL
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportRegistrantStatusAging]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Jan 8, 2015
-- Description:	Used for the AHOBPR Aging Report  -- exec [AHOBPR].[SP_ReportRegistrantStatusAging]    (More options at bottom)
-- Note: All 7 Registrant Status rows will be returned as possible values, so some rows may have all zeros.
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportRegistrantStatusAging]
       @AsOfDate DATETIME2(0) = NULL,  
       @SvcStatus  VARCHAR(50) = '',         -- 'Veteran', 'Retiree', 'Active Duty'
       @InstitutionId INT = 0,               -- 1000109,  1000089
       @VisnId VARCHAR(50) = ''              -- 'V16', 'V01'
AS
BEGIN

  SET @AsOfDate = dbo.AddMaxTime(ISNULL(@AsOfDate,GETDATE()));  -- adds 23:59:59
  
  WITH MostRecent
  AS (  
      SELECT Metrics.REGISTRANT_ID, 
             MAX(Metrics.PROCESS_METRICS_ID) AS MaxMetricsID
        FROM [AHOBPR].[PROCESS_METRICS] Metrics
        JOIN AHOBPR.STD_PROCESS_METRICS_TYPE ProcessType
          ON ProcessType.STD_PROCESS_METRICS_TYPE_ID = Metrics.STD_PROCESS_METRICS_TYPE_ID
       WHERE ProcessType.PROCESS_METRICS = 'Registrant Status Change'
         AND Metrics.CREATED <= @AsOfDate
       GROUP BY [REGISTRANT_ID]
     ),
  Stat 
  AS (
      SELECT this.[REGISTRANT_ID], 
             this.PROCESS_METRICS_VALUE, 
             this.CREATED AS StatusDate,
             DATEDIFF(DAY, this.CREATED, @AsOfDate) AS DaysDiff
        FROM [AHOBPR].[PROCESS_METRICS] this
        JOIN MostRecent
          ON MostRecent.MaxMetricsID = this.PROCESS_METRICS_ID    
      ),
  Summary
  AS (  
      SELECT Stat.PROCESS_METRICS_VALUE,
             SUM(CASE WHEN( Stat.DaysDiff < 31) THEN 1 ELSE 0 END) AS Age0to30,
             SUM(CASE WHEN( Stat.DaysDiff BETWEEN 31 AND 60) THEN 1 ELSE 0 END) AS Age31to60,
             SUM(CASE WHEN( Stat.DaysDiff BETWEEN 61 AND 90) THEN 1 ELSE 0 END) AS Age61to90,
             SUM(CASE WHEN( Stat.DaysDiff > 90) THEN 1 ELSE 0 END) AS Age91plus,       
             Count(*) AS TotalCount
	      FROM AHOBPR.REGISTRANT reg
	      JOIN Stat
	        ON reg.REGISTRANT_ID = Stat.REGISTRANT_ID
		    JOIN AHOBPR.STD_SERVICE_STATUS svc
		      ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID
		    LEFT JOIN dbo.viewFacilitiesByVisn inst
		      ON inst.institution_id = reg.STD_INSTITUTION_ID
 	     WHERE (svc.SERVICE_STATUS = @SvcStatus
	            OR ISNULL(@SvcStatus,'') = '')	
         AND (reg.STD_INSTITUTION_ID =  @InstitutionId
              OR ISNULL(@InstitutionId,0) = 0) 
         AND (inst.VisnID =  @VisnID
              OR ISNULL(@VisnID,'') = '') 
    GROUP BY Stat.PROCESS_METRICS_VALUE
    )       
    SELECT Possible.ORDINAL_VALUE, 
           Possible.REGISTRANT_STATUS,
           ISNULL(Summary.Age0to30,0)    AS Age0to30,
           ISNULL(Summary.Age31to60, 0)  AS Age31to60,
           ISNULL(Summary.Age61to90, 0)  AS Age61to90,
           ISNULL(Summary.Age91plus, 0)  AS Age91plus,
           ISNULL(Summary.TotalCount, 0) AS TotalCount
      FROM [AHOBPR].[STD_REGISTRANT_STATUS] Possible
      LEFT JOIN Summary
        ON Summary.PROCESS_METRICS_VALUE = Possible.REGISTRANT_STATUS
  ORDER BY Possible.ORDINAL_VALUE;                                                                                                   
END

-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20141130', '', 0, ''
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20150130', 'Veteran', 0, ''
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20150122', 'Retiree',  0, ''
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20150122', 'Active Duty', 0, ''
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20150122', '', 1000109, ''
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20150122', '', 0, 'V01'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportStatusByLocation]...';


GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Status by Location Report

-- Modification log
-- 20150114 - Sherry Wang: Changed query for @InstitutionId and @VisnId
-- 20150202 - Change state to use state codes, removed unneeded tables and joins, Removed Distinct
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportStatusByLocation]
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL 
       @status varchar(1000) = NULL, -- Multiple statues, comma-separated values when not NULL        
       @InstitutionId INT = 0,               -- 1000109,  1000089
       @VisnId VARCHAR(50) = ''              -- 'V16', 'V01'
AS
BEGIN
  DECLARE @Today DATETIME2 = GETDATE();
  
  Print @state;
 
 --Temp table concatnate flags for Registrants with multiple flags
CREATE TABLE #state
(
   [Registrant_Id] INT,
   [state] VARCHAR(8000)
) 

INSERT INTO #state ([Registrant_Id], [state])
-- Load Table
 SELECT a.REGISTRANT_ID, 
        STUFF((SELECT ', ' + b.STATE 
        FROM AHOBPR.REGISTRANT_ADDRESS b 
       WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
              FOR XML PATH('')), 1, 1, '')  [STATE]
        FROM AHOBPR.REGISTRANT a
    GROUP BY a.REGISTRANT_ID
    ORDER BY a.REGISTRANT_ID;
 
	SELECT  a.REGISTRANT_ID
		     ,(a.LAST_NAME + ', ' + a.FIRST_NAME) AS Name
		     ,b.REGISTRANT_STATUS AS Status
		     ,DATEDIFF(day, a.REGISTRANT_STATUS_LAST_UPDATED_DATE, @Today) As Days
		     ,s.STATE AS State
		     ,RIGHT(inst.VisnID, 2)  AS VISN
		     ,inst.Name AS Facility
		     ,a.BIRTH_DATE AS BirthDate
         ,CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay
	  FROM AHOBPR.REGISTRANT a
		JOIN AHOBPR.STD_REGISTRANT_STATUS b 
		  ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID
	  LEFT JOIN dbo.viewFacilitiesByVisn inst
		  ON inst.institution_id = a.STD_INSTITUTION_ID
		LEFT JOIN #state s
		  ON a.REGISTRANT_ID = s.Registrant_Id
	 WHERE (ISNULL(@state,'') = ''
	       OR EXISTS(SELECT DISTINCT addr.REGISTRANT_ID 
	                   FROM AHOBPR.REGISTRANT_ADDRESS addr 
	                  WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID 
	                    AND addr.STATE  IN (SELECT * FROM fncSplit(@state, ','))))
	 	 AND (ISNULL(@status,'') = '' 
	 	     OR a.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@status, ',')))
		 AND (ISNULL(@InstitutionId,0) = 0 
		     OR a.STD_INSTITUTION_ID =  @InstitutionId) 
		 AND (ISNULL(@VisnID,'') = '' 
		     OR inst.VisnID =  @VisnID); 

  DROP TABLE #state
END

-- EXEC [AHOBPR].[SP_ReportStatusByLocation] 
-- EXEC [AHOBPR].[SP_ReportStatusByLocation] @state = 'NC'
-- EXEC [AHOBPR].[SP_ReportStatusByLocation] @status = 7
-- EXEC [AHOBPR].[SP_ReportStatusByLocation] @InstitutionId = 1000089
-- EXEC [AHOBPR].[SP_ReportStatusByLocation] @VisnId = 'V01'
GO
PRINT N'Creating [AHOBPR].[SP_ReportAdHocByIndivdual]...';


GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters and remove NULLs from display where possible
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_EVALUATION
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByIndivdual]
       @status varchar(1000) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL  
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(1000) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(8000) = NULL,
       @healthConcerns varchar(10) = 'All', 
       @requestToBeSeen varchar(10) = 'All',
       @InstitutionId INT = 0,               -- 1000109,  1000089
       @VisnId VARCHAR(50) = '',              -- 'V16', 'V01'    
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL;

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	
	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
  --Concatenate one or more Sub-population flags for Registrants with flags
  CREATE TABLE #SubpopulationFlags
  (
     [Registrant_Id] INT,
     [Registry_Flag_Name] VARCHAR(8000)
  ); 

  INSERT INTO #SubpopulationFlags ([Registrant_Id], [Registry_Flag_Name])
  SELECT a.REGISTRANT_ID, 
         STUFF((SELECT ', ' + c.REGISTRY_FLAG_NAME 
                  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b 
                  JOIN AHOBPR.STD_REGISTRY_FLAG c 
                    ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID
                 WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                   AND c.STD_REGISTRY_FLAG_TYPE_ID = @SubPopType
                 FOR XML PATH('')), 1, 1, '') AS [REGISTRY_FLAG_NAME]
        FROM AHOBPR.REGISTRANT a
    GROUP BY a.REGISTRANT_ID
    ORDER BY a.REGISTRANT_ID;

  --Concatenate one or more Admin flags for Registrants with flags
  CREATE TABLE #AdminFlags
  (
     [Registrant_Id] INT,
     [Registry_Flag_Name] VARCHAR(8000)
  );
    
  INSERT INTO #AdminFlags ([Registrant_Id], [Registry_Flag_Name])
  SELECT a.REGISTRANT_ID, 
         STUFF((SELECT distinct ', ' + c.REGISTRY_FLAG_NAME 
                  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b 
                  JOIN AHOBPR.STD_REGISTRY_FLAG c 
                    ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID
                 WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                   AND c.STD_REGISTRY_FLAG_TYPE_ID = @AdminType
                   FOR XML PATH('')), 1, 1, '') AS [REGISTRY_FLAG_NAME]
    FROM AHOBPR.REGISTRANT a
   GROUP BY a.REGISTRANT_ID
   ORDER BY a.REGISTRANT_ID;

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  CREATE TABLE #DeploymentCountry
  (
     [Registrant_Id] INT,
     [DeploymentCountry] VARCHAR(8000)
  ); 

  INSERT INTO #DeploymentCountry ([Registrant_Id], [DeploymentCountry])
  SELECT a.REGISTRANT_ID, 
         STUFF((SELECT distinct ', ' + b.DEPLOYMENT_COUNTRY 
                  FROM AHOBPR.REGISTRANT_DEPLOYMENT b 
                 WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                   FOR XML PATH('')), 1, 1, '') AS DEPLOYMENT_COUNTRY
        FROM AHOBPR.REGISTRANT a
    GROUP BY a.REGISTRANT_ID
    ORDER BY a.REGISTRANT_ID;

--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SELECT DISTINCT a.REGISTRANT_ID
          ,(a.LAST_NAME + ', ' + a.FIRST_NAME) AS Name
          ,b.REGISTRANT_STATUS AS Status
          ,c.SERVICE_STATUS AS DutyStatus
          ,e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate
          ,e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate
          ,ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'') AS QuestionStartDateDisplay
          ,ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'') AS QuestionCompleteDateDisplay
          ,'' AS QuestionNumber
          ,'' AS Answer
          ,ISNULL(a.HEALTH_CONCERNS_RESPONSE,'') AS HealthConcerns 
          ,ISNULL(a.REQUEST_SEEN_RESPONSE,'')  AS RequestBeSeen 
          ,RTRIM(LTRIM(ISNULL(l.REGISTRY_FLAG_NAME,''))) AS SubpopulationFlag 
          ,RTRIM(LTRIM(ISNULL(m.REGISTRY_FLAG_NAME,''))) AS AdminFlag 
          ,ISNULL(deploy.DeploymentCountry,'') AS DeploymentCountry		
		      ,a.BIRTH_DATE AS BirthDate
		      ,CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay
	  FROM AHOBPR.REGISTRANT a
		JOIN AHOBPR.STD_REGISTRANT_STATUS b 
		  ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID
	  JOIN AHOBPR.STD_SERVICE_STATUS c 
		  ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID
		LEFT JOIN AHOBPR.FORM_RESPONSE d 
		  ON a.REGISTRANT_ID =  d.REGISTRANT_ID
		LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e 
		  ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID
		LEFT JOIN #SubpopulationFlags l 
		  ON a.REGISTRANT_ID = l.REGISTRANT_ID 
		LEFT JOIN #AdminFlags m 
		  ON a.REGISTRANT_ID = m.REGISTRANT_ID 
		LEFT JOIN dbo.viewFacilitiesByVisn inst
		  ON inst.institution_id = a.STD_INSTITUTION_ID
		LEFT JOIN AHOBPR.REGISTRANT_DEPLOYMENT deploymentAll
		  on a.REGISTRANT_ID = deploymentAll.REGISTRANT_ID
		LEFT JOIN #DeploymentCountry deploy
		  on a.REGISTRANT_ID = deploy.REGISTRANT_ID
	 WHERE (a.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@status, ','))OR ISNULL(@status,'') = '') 
     AND (c.STD_SERVICE_STATUS_ID IN (SELECT * FROM fncSplit(@dutyStatus, ',')) OR ISNULL(@dutyStatus,'') = '') 
     AND (( e.QUESTIONNAIRE_STARTED_DATE >= @formStartFromDate) OR @formStartFromDate IS NULL) 
     AND (( e.QUESTIONNAIRE_STARTED_DATE <= @formStartToDate) OR @formStartToDate IS NULL) 
     AND (( e.QUESTIONNAIRE_COMPLETED_DATE >= @formCompletionFromDate) OR @formCompletionFromDate IS NULL) 
     AND (( e.QUESTIONNAIRE_COMPLETED_DATE <= @formCompletionToDate) OR @formCompletionToDate IS NULL) 
     AND ((a.HEALTH_CONCERNS_RESPONSE = @healthConcerns) OR @healthConcerns = 'All') 
     AND ((a.REQUEST_SEEN_RESPONSE = @requestToBeSeen) OR @requestToBeSeen = 'All') 
	   AND ((ISNULL(@subpopulationFlag,'') = '')
	         OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop
	                   WHERE subpop.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@subpopulationFlag, ','))
	                     AND subpop.REGISTRANT_ID = a.REGISTRANT_ID))
	   AND ((ISNULL(@adminFlag,'') = '')
 	         OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag
                      WHERE adminflag.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@adminFlag, ','))
                        AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID
                        AND adminflag.CREATED BETWEEN @adminFlagFromDate AND @adminFlagToDate))  
     AND (ISNULL(@InstitutionId,0) = 0
          OR a.STD_INSTITUTION_ID = @InstitutionId 
          OR(@InstitutionId = -1 AND a.STD_INSTITUTION_ID IS NULL)) 
     AND (inst.VisnID =  @VisnID OR ISNULL(@VisnID,'') = '') 
     AND (ISNULL(@healthFactor,'') = ''
          OR EXISTS (SELECT re.REGISTRANT_ID 
                       FROM AHOBPR.REGISTRANT_EVALUATION re
                       JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf 
                         ON re.REGISTRANT_EVALUATION_ID = hf.REGISTRANT_EVALUATION_ID
		                  WHERE a.REGISTRANT_ID = re.REGISTRANT_ID
		                  AND hf.STD_HEALTH_FACTOR_ID IN (SELECT * FROM fncSplit(@healthFactor, ','))))
     AND (deploymentAll.DEPLOYMENT_COUNTRY = @deploymentAll OR ISNULL(@deploymentAll,'') = '')
     AND (ISNULL(@deploymentExposure,'') = '' 
          OR EXISTS(SELECT deploymentExposure.REGISTRANT_ID 
                      FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure 
	                    JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure
	                      ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID
	                    JOIN AHOBPR.STD_FORM_QUESTION quest
	                      ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID
	                   WHERE quest.FORM_QUESTION_UNIQUE_ID = '1.2.A'
	                     AND deploymentExposure.DEPLOYMENT_COUNTRY = @deploymentExposure 
	                     AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID))
     
  ELSE -- QuestionNumber not blank
    SELECT DISTINCT a.REGISTRANT_ID
          ,(a.LAST_NAME + ', ' + a.FIRST_NAME) AS Name
          ,b.REGISTRANT_STATUS AS Status
          ,c.SERVICE_STATUS AS DutyStatus
          ,e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate
          ,e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate
          ,ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'') AS QuestionStartDateDisplay
          ,ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'') AS QuestionCompleteDateDisplay
          ,stdQuestion.FORM_QUESTION_UNIQUE_ID AS QuestionNumber
          ,STUFF((SELECT ', ' + stdAnswer.TEXT 
                  FROM AHOBPR.FORM_RESPONSE_ANSWER answer 
                  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer 
                    ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID
                 WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID
                 FOR XML PATH('')), 1, 1, '') AS Answer                 
          ,ISNULL(a.HEALTH_CONCERNS_RESPONSE,'') AS HealthConcerns 
          ,ISNULL(a.REQUEST_SEEN_RESPONSE,'')  AS RequestBeSeen 
          ,RTRIM(LTRIM(ISNULL(l.REGISTRY_FLAG_NAME,''))) AS SubpopulationFlag 
          ,RTRIM(LTRIM(ISNULL(m.REGISTRY_FLAG_NAME,''))) AS AdminFlag 
          ,ISNULL(deploy.DeploymentCountry,'') AS DeploymentCountry		
		      ,a.BIRTH_DATE AS BirthDate
		      ,CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay
	  FROM AHOBPR.REGISTRANT a
		JOIN AHOBPR.STD_REGISTRANT_STATUS b 
		  ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID
		JOIN AHOBPR.STD_SERVICE_STATUS c 
		  ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID
		LEFT JOIN AHOBPR.FORM_RESPONSE d 
		  ON a.REGISTRANT_ID =  d.REGISTRANT_ID
		LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e 
		  ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID
		LEFT JOIN AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag 
		  ON a.REGISTRANT_ID = adminflag.REGISTRANT_ID
		LEFT JOIN #SubpopulationFlags l 
		  ON a.REGISTRANT_ID = l.REGISTRANT_ID 
		LEFT JOIN #AdminFlags m 
		  ON a.REGISTRANT_ID = m.REGISTRANT_ID 
		LEFT JOIN dbo.viewFacilitiesByVisn inst
		  ON inst.institution_id = a.STD_INSTITUTION_ID
		LEFT JOIN AHOBPR.REGISTRANT_DEPLOYMENT deploymentAll
		  ON a.REGISTRANT_ID = deploymentAll.REGISTRANT_ID
    JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion 
      ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID
    JOIN AHOBPR.STD_FORM_QUESTION stdQuestion 
		  ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID
		LEFT JOIN #DeploymentCountry deploy
		  on a.REGISTRANT_ID = deploy.REGISTRANT_ID
	 WHERE (a.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@status, ','))OR ISNULL(@status,'') = '') 
     AND (c.STD_SERVICE_STATUS_ID IN (SELECT * FROM fncSplit(@dutyStatus, ',')) OR ISNULL(@dutyStatus,'') = '') 
     AND (( e.QUESTIONNAIRE_STARTED_DATE >= @formStartFromDate) OR @formStartFromDate IS NULL) 
     AND (( e.QUESTIONNAIRE_STARTED_DATE <= @formStartToDate) OR @formStartToDate IS NULL) 
     AND (( e.QUESTIONNAIRE_COMPLETED_DATE >= @formCompletionFromDate) OR @formCompletionFromDate IS NULL) 
     AND (( e.QUESTIONNAIRE_COMPLETED_DATE <= @formCompletionToDate) OR @formCompletionToDate IS NULL) 
     AND ((a.HEALTH_CONCERNS_RESPONSE = @healthConcerns) OR @healthConcerns = 'All') 
     AND ((a.REQUEST_SEEN_RESPONSE = @requestToBeSeen) OR @requestToBeSeen = 'All') 
	   AND ((ISNULL(@subpopulationFlag,'') = '')
	         OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop
	                   WHERE subpop.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@subpopulationFlag, ','))
	                     AND subpop.REGISTRANT_ID = a.REGISTRANT_ID))
	   AND ((ISNULL(@adminFlag,'') = '')
 	         OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag
                      WHERE adminflag.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@adminFlag, ','))
                        AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID
                        AND adminflag.CREATED BETWEEN @adminFlagFromDate AND @adminFlagToDate))  
     AND (ISNULL(@InstitutionId,0) = 0
          OR a.STD_INSTITUTION_ID = @InstitutionId 
          OR(@InstitutionId = -1 AND a.STD_INSTITUTION_ID IS NULL)) 
     AND (inst.VisnID =  @VisnID OR ISNULL(@VisnID,'') = '') 
     AND (ISNULL(@healthFactor,'') = ''
          OR EXISTS (SELECT re.REGISTRANT_ID 
                       FROM AHOBPR.REGISTRANT_EVALUATION re
                       JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf 
                         ON re.REGISTRANT_EVALUATION_ID = hf.REGISTRANT_EVALUATION_ID
		                  WHERE a.REGISTRANT_ID = re.REGISTRANT_ID
		                  AND hf.STD_HEALTH_FACTOR_ID IN (SELECT * FROM fncSplit(@healthFactor, ','))))		                  
     AND (deploymentAll.DEPLOYMENT_COUNTRY = @deploymentAll OR ISNULL(@deploymentAll,'') = '')
      AND (ISNULL(@deploymentExposure,'') = '' 
      OR EXISTS(SELECT deploymentExposure.REGISTRANT_ID 
                  FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure 
                  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure
                    ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID
                  JOIN AHOBPR.STD_FORM_QUESTION quest
                    ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID
                 WHERE quest.FORM_QUESTION_UNIQUE_ID = '1.2.A'
                   AND deploymentExposure.DEPLOYMENT_COUNTRY = @deploymentExposure 
                   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID))
	   AND (stdQuestion.FORM_QUESTION_UNIQUE_ID = @questionNumber) 
     AND (ISNULL(@answer,'') = '' 
           OR EXISTS 
              (
               SELECT x.STD_FORM_ANSWER_ID
                 FROM AHOBPR.STD_FORM_QUESTION w
                 JOIN AHOBPR.STD_FORM_ANSWER x 
                   ON w.STD_FORM_QUESTION_ID = x.STD_FORM_QUESTION_ID
                 JOIN AHOBPR.FORM_RESPONSE_ANSWER rAns
                   ON rAns.STD_FORM_ANSWER_ID = x.STD_FORM_ANSWER_ID
                WHERE w.FORM_QUESTION_UNIQUE_ID = @questionNumber
                  AND EXISTS(SELECT [TEXT] 
                               FROM AHOBPR.STD_FORM_ANSWER 
                              WHERE STD_FORM_ANSWER_ID IN (SELECT * FROM fncSplit(@answer, ','))
                                AND TEXT = x.TEXT )
                  AND rAns.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID)
         );
         
  DROP TABLE #SubpopulationFlags				
  DROP TABLE #AdminFlags				
  DROP TABLE #DeploymentCountry
END

-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @status = 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @dutyStatus = 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @formStartFromDateText  = 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @formStartToDateText 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @formCompletionFromDateText 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @formCompletionToDateText 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @requestToBeSeen = 'Yes'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @VisnId = 'V01'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @InstitutionId = -1
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @InstitutionId = 1000109
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @adminFlag = '59,60'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @deploymentAll 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @deploymentExposure 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @adminFlagFromDateText 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @adminFlagToDateText 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndivdual] @questionNumber = '1.2.E'  , @answer = '19'  
GO
PRINT N'Creating [AHOBPR].[SP_ReportAdHocByLocation]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters, Add distinct and outer query to group counts.
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_EVALUATION
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByLocation]
       @status varchar(1000) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL  
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(1000) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(8000) = NULL,
       @healthConcerns varchar(10) = 'All', 
       @requestToBeSeen varchar(10) = 'All',
       @groupBy VARCHAR(50) = '',                 -- 'VISN' or 'Facility'   
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL
AS

BEGIN

DECLARE @formStartFromDate DATETIME2(0) = NULL,
        @formStartToDate DATETIME2(0) = NULL,
        @formCompletionFromDate DATETIME2(0) = NULL,
        @formCompletionToDate DATETIME2(0) = NULL,
        @adminFlagFromDate DATETIME2(0) = NULL,
        @adminFlagToDate DATETIME2(0) = NULL;

-- Convert date parameters      

   SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
   SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
   SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
   SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
   SET @adminFlagFromDate = dbo.CleanDate(@adminFlagFromDateText);
   SET @adminFlagToDate = dbo.AddMaxTime(dbo.CleanDate(@adminFlagToDateText)); 

  -- Group by Facility with No Question selected 
  IF @groupBy = 'Facility'  AND ISNULL(@questionNumber,'') = ''
    SELECT Location,		
		  CONVERT(VARCHAR(10), LocationId) AS LocationId,		
		  COUNT(*) AS TotalRegistrants	
			FROM (		
          SELECT DISTINCT ISNULL(inst.Name, 'Other') AS Location,		
				         ISNULL(a.STD_INSTITUTION_ID, '-1') AS LocationId,		
				         a.REGISTRANT_ID	
	  	        FROM AHOBPR.REGISTRANT a
		      JOIN AHOBPR.STD_REGISTRANT_STATUS b 
		        ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID
	        JOIN AHOBPR.STD_SERVICE_STATUS c 
		        ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID
		      LEFT JOIN AHOBPR.FORM_RESPONSE d 
		        ON a.REGISTRANT_ID =  d.REGISTRANT_ID
		      LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e 
		        ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID	  
		      LEFT JOIN dbo.viewFacilitiesByVisn inst
		        ON inst.institution_id = a.STD_INSTITUTION_ID
		      LEFT JOIN AHOBPR.REGISTRANT_DEPLOYMENT deploymentAll
		        on a.REGISTRANT_ID = deploymentAll.REGISTRANT_ID
	       WHERE (a.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@status, ','))OR ISNULL(@status,'') = '') 
           AND (c.STD_SERVICE_STATUS_ID IN (SELECT * FROM fncSplit(@dutyStatus, ',')) OR ISNULL(@dutyStatus,'') = '') 
           AND (( e.QUESTIONNAIRE_STARTED_DATE >= @formStartFromDate) OR @formStartFromDate IS NULL) 
           AND (( e.QUESTIONNAIRE_STARTED_DATE <= @formStartToDate) OR @formStartToDate IS NULL) 
           AND (( e.QUESTIONNAIRE_COMPLETED_DATE >= @formCompletionFromDate) OR @formCompletionFromDate IS NULL) 
           AND (( e.QUESTIONNAIRE_COMPLETED_DATE <= @formCompletionToDate) OR @formCompletionToDate IS NULL) 
           AND ((a.HEALTH_CONCERNS_RESPONSE = @healthConcerns) OR @healthConcerns = 'All') 
           AND ((a.REQUEST_SEEN_RESPONSE = @requestToBeSeen) OR @requestToBeSeen = 'All') 
	         AND ((ISNULL(@subpopulationFlag,'') = '')
	               OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop
	                         WHERE subpop.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@subpopulationFlag, ','))
	                           AND subpop.REGISTRANT_ID = a.REGISTRANT_ID))
	         AND ((ISNULL(@adminFlag,'') = '')
 	               OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag
                            WHERE adminflag.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@adminFlag, ','))
                              AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID
                              AND adminflag.CREATED BETWEEN @adminFlagFromDate AND @adminFlagToDate))             
           AND (ISNULL(@healthFactor,'') = ''
            OR EXISTS (SELECT re.REGISTRANT_ID 
                         FROM AHOBPR.REGISTRANT_EVALUATION re
                         JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf 
                           ON re.REGISTRANT_EVALUATION_ID = hf.REGISTRANT_EVALUATION_ID
		                    WHERE a.REGISTRANT_ID = re.REGISTRANT_ID
		                    AND hf.STD_HEALTH_FACTOR_ID IN (SELECT * FROM fncSplit(@healthFactor, ','))))
           AND (deploymentAll.DEPLOYMENT_COUNTRY = @deploymentAll OR ISNULL(@deploymentAll,'') = '')
           AND (ISNULL(@deploymentExposure,'') = '' 
                OR EXISTS(SELECT deploymentExposure.REGISTRANT_ID 
                            FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure 
	                          JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure
	                            ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID
	                          JOIN AHOBPR.STD_FORM_QUESTION quest
	                            ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID
	                         WHERE quest.FORM_QUESTION_UNIQUE_ID = '1.2.A'
	                           AND deploymentExposure.DEPLOYMENT_COUNTRY = @deploymentExposure 
	                           AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID))
	    )  results
  		GROUP BY Location, LocationID	;	
  
  -- Group by VISN with No Question selected 
	IF @groupBy = 'VISN' AND ISNULL(@questionNumber,'') = ''
    SELECT Location,		
				   LocationId,		
				   COUNT(*) AS TotalRegistrants	
			FROM (		
          SELECT DISTINCT ISNULL(inst.VisnID, 'Other') AS Location,		
				         ISNULL(inst.VisnID, '-1') AS LocationId,		
				         a.REGISTRANT_ID			
	  	        FROM AHOBPR.REGISTRANT a
		      JOIN AHOBPR.STD_REGISTRANT_STATUS b 
		        ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID
	        JOIN AHOBPR.STD_SERVICE_STATUS c 
		        ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID
		      LEFT JOIN AHOBPR.FORM_RESPONSE d 
		        ON a.REGISTRANT_ID =  d.REGISTRANT_ID
		      LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e 
		        ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID	  
		      LEFT JOIN dbo.viewFacilitiesByVisn inst
		        ON inst.institution_id = a.STD_INSTITUTION_ID
		      LEFT JOIN AHOBPR.REGISTRANT_DEPLOYMENT deploymentAll
		        on a.REGISTRANT_ID = deploymentAll.REGISTRANT_ID
	       WHERE (a.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@status, ','))OR ISNULL(@status,'') = '') 
           AND (c.STD_SERVICE_STATUS_ID IN (SELECT * FROM fncSplit(@dutyStatus, ',')) OR ISNULL(@dutyStatus,'') = '') 
           AND (( e.QUESTIONNAIRE_STARTED_DATE >= @formStartFromDate) OR @formStartFromDate IS NULL) 
           AND (( e.QUESTIONNAIRE_STARTED_DATE <= @formStartToDate) OR @formStartToDate IS NULL) 
           AND (( e.QUESTIONNAIRE_COMPLETED_DATE >= @formCompletionFromDate) OR @formCompletionFromDate IS NULL) 
           AND (( e.QUESTIONNAIRE_COMPLETED_DATE <= @formCompletionToDate) OR @formCompletionToDate IS NULL) 
           AND ((a.HEALTH_CONCERNS_RESPONSE = @healthConcerns) OR @healthConcerns = 'All') 
           AND ((a.REQUEST_SEEN_RESPONSE = @requestToBeSeen) OR @requestToBeSeen = 'All') 
	         AND ((ISNULL(@subpopulationFlag,'') = '')
	               OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop
	                         WHERE subpop.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@subpopulationFlag, ','))
	                           AND subpop.REGISTRANT_ID = a.REGISTRANT_ID))
	         AND ((ISNULL(@adminFlag,'') = '')
 	               OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag
                            WHERE adminflag.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@adminFlag, ','))
                              AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID
                              AND adminflag.CREATED BETWEEN @adminFlagFromDate AND @adminFlagToDate))    
           AND (ISNULL(@healthFactor,'') = ''
            OR EXISTS (SELECT re.REGISTRANT_ID 
                         FROM AHOBPR.REGISTRANT_EVALUATION re
                         JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf 
                           ON re.REGISTRANT_EVALUATION_ID = hf.REGISTRANT_EVALUATION_ID
		                    WHERE a.REGISTRANT_ID = re.REGISTRANT_ID
		                    AND hf.STD_HEALTH_FACTOR_ID IN (SELECT * FROM fncSplit(@healthFactor, ','))))
           AND (deploymentAll.DEPLOYMENT_COUNTRY = @deploymentAll OR ISNULL(@deploymentAll,'') = '')
           AND (ISNULL(@deploymentExposure,'') = '' 
                OR EXISTS(SELECT deploymentExposure.REGISTRANT_ID 
                            FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure 
	                          JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure
	                            ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID
	                          JOIN AHOBPR.STD_FORM_QUESTION quest
	                            ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID
	                         WHERE quest.FORM_QUESTION_UNIQUE_ID = '1.2.A'
	                           AND deploymentExposure.DEPLOYMENT_COUNTRY = @deploymentExposure 
	                           AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID))  
	    )  results
  		GROUP BY Location, LocationID	;	

-- By Facility With Question Selected
	IF @groupBy = 'Facility' AND ISNULL(@questionNumber,'') <> ''
    SELECT Location,		
				   CONVERT(VARCHAR(10), LocationId) AS LocationId,		
				   COUNT(*) AS TotalRegistrants	
			FROM (		
	         SELECT DISTINCT ISNULL(inst.Name, 'Other') AS Location,		
				         ISNULL(a.STD_INSTITUTION_ID, '-1') AS LocationId,		
				         a.REGISTRANT_ID	
	        FROM AHOBPR.REGISTRANT a
		      JOIN AHOBPR.STD_REGISTRANT_STATUS b 
		        ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID
		      JOIN AHOBPR.STD_SERVICE_STATUS c 
		        ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID
		      LEFT JOIN AHOBPR.FORM_RESPONSE d 
		        ON a.REGISTRANT_ID =  d.REGISTRANT_ID
		      LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e 
		        ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID
		      LEFT JOIN AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag 
		        ON a.REGISTRANT_ID = adminflag.REGISTRANT_ID
		      LEFT JOIN dbo.viewFacilitiesByVisn inst
		        ON inst.institution_id = a.STD_INSTITUTION_ID
		      LEFT JOIN AHOBPR.REGISTRANT_DEPLOYMENT deploymentAll
		        ON a.REGISTRANT_ID = deploymentAll.REGISTRANT_ID
          JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion 
            ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID
          JOIN AHOBPR.STD_FORM_QUESTION stdQuestion 
		        ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID
	       WHERE (a.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@status, ','))OR ISNULL(@status,'') = '') 
           AND (c.STD_SERVICE_STATUS_ID IN (SELECT * FROM fncSplit(@dutyStatus, ',')) OR ISNULL(@dutyStatus,'') = '') 
           AND (( e.QUESTIONNAIRE_STARTED_DATE >= @formStartFromDate) OR @formStartFromDate IS NULL) 
           AND (( e.QUESTIONNAIRE_STARTED_DATE <= @formStartToDate) OR @formStartToDate IS NULL) 
           AND (( e.QUESTIONNAIRE_COMPLETED_DATE >= @formCompletionFromDate) OR @formCompletionFromDate IS NULL) 
           AND (( e.QUESTIONNAIRE_COMPLETED_DATE <= @formCompletionToDate) OR @formCompletionToDate IS NULL) 
           AND ((a.HEALTH_CONCERNS_RESPONSE = @healthConcerns) OR @healthConcerns = 'All') 
           AND ((a.REQUEST_SEEN_RESPONSE = @requestToBeSeen) OR @requestToBeSeen = 'All') 
	         AND ((ISNULL(@subpopulationFlag,'') = '')
	               OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop
	                         WHERE subpop.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@subpopulationFlag, ','))
	                           AND subpop.REGISTRANT_ID = a.REGISTRANT_ID))
	         AND ((ISNULL(@adminFlag,'') = '')
 	               OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag
                            WHERE adminflag.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@adminFlag, ','))
                              AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID
                              AND adminflag.CREATED BETWEEN @adminFlagFromDate AND @adminFlagToDate))  
           AND (ISNULL(@healthFactor,'') = ''
            OR EXISTS (SELECT re.REGISTRANT_ID 
                         FROM AHOBPR.REGISTRANT_EVALUATION re
                         JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf 
                           ON re.REGISTRANT_EVALUATION_ID = hf.REGISTRANT_EVALUATION_ID
		                    WHERE a.REGISTRANT_ID = re.REGISTRANT_ID
		                    AND hf.STD_HEALTH_FACTOR_ID IN (SELECT * FROM fncSplit(@healthFactor, ','))))
           AND (deploymentAll.DEPLOYMENT_COUNTRY = @deploymentAll OR ISNULL(@deploymentAll,'') = '')
            AND (ISNULL(@deploymentExposure,'') = '' 
            OR EXISTS(SELECT deploymentExposure.REGISTRANT_ID 
                        FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure 
                        JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure
                          ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID
                        JOIN AHOBPR.STD_FORM_QUESTION quest
                          ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID
                       WHERE quest.FORM_QUESTION_UNIQUE_ID = '1.2.A'
                         AND deploymentExposure.DEPLOYMENT_COUNTRY = @deploymentExposure 
                         AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID))
	         AND (stdQuestion.FORM_QUESTION_UNIQUE_ID = @questionNumber) 
           AND (ISNULL(@answer,'') = '' 
                 OR EXISTS 
                    (
                     SELECT x.STD_FORM_ANSWER_ID
                       FROM AHOBPR.STD_FORM_QUESTION w
                       JOIN AHOBPR.STD_FORM_ANSWER x 
                         ON w.STD_FORM_QUESTION_ID = x.STD_FORM_QUESTION_ID
                       JOIN AHOBPR.FORM_RESPONSE_ANSWER rAns
                         ON rAns.STD_FORM_ANSWER_ID = x.STD_FORM_ANSWER_ID
                      WHERE w.FORM_QUESTION_UNIQUE_ID = @questionNumber
                        AND EXISTS(SELECT [TEXT] 
                                     FROM AHOBPR.STD_FORM_ANSWER 
                                    WHERE STD_FORM_ANSWER_ID IN (SELECT * FROM fncSplit(@answer, ','))
                                      AND TEXT = x.TEXT )
                        AND rAns.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID)
               )				   	
	    )  results
  		GROUP BY Location, LocationID	;		

-- By VISN With Question Selected	
	IF @groupBy = 'VISN' AND ISNULL(@questionNumber,'') <> ''
    SELECT Location,		
				   LocationId,		
				   COUNT(*) AS TotalRegistrants	
		 FROM (
	         SELECT DISTINCT ISNULL(inst.VisnID, 'Other') AS Location,		
				         ISNULL(inst.VisnID, '-1') AS LocationId,		
				         a.REGISTRANT_ID	
	        FROM AHOBPR.REGISTRANT a
		      JOIN AHOBPR.STD_REGISTRANT_STATUS b 
		        ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID
		      JOIN AHOBPR.STD_SERVICE_STATUS c 
		        ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID
		      LEFT JOIN AHOBPR.FORM_RESPONSE d 
		        ON a.REGISTRANT_ID =  d.REGISTRANT_ID
		      LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e 
		        ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID
		      LEFT JOIN AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag 
		        ON a.REGISTRANT_ID = adminflag.REGISTRANT_ID
		      LEFT JOIN dbo.viewFacilitiesByVisn inst
		        ON inst.institution_id = a.STD_INSTITUTION_ID
		      LEFT JOIN AHOBPR.REGISTRANT_DEPLOYMENT deploymentAll
		        ON a.REGISTRANT_ID = deploymentAll.REGISTRANT_ID
          JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion 
            ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID
          JOIN AHOBPR.STD_FORM_QUESTION stdQuestion 
		        ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID
	       WHERE (a.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@status, ','))OR ISNULL(@status,'') = '') 
           AND (c.STD_SERVICE_STATUS_ID IN (SELECT * FROM fncSplit(@dutyStatus, ',')) OR ISNULL(@dutyStatus,'') = '') 
           AND (( e.QUESTIONNAIRE_STARTED_DATE >= @formStartFromDate) OR @formStartFromDate IS NULL) 
           AND (( e.QUESTIONNAIRE_STARTED_DATE <= @formStartToDate) OR @formStartToDate IS NULL) 
           AND (( e.QUESTIONNAIRE_COMPLETED_DATE >= @formCompletionFromDate) OR @formCompletionFromDate IS NULL) 
           AND (( e.QUESTIONNAIRE_COMPLETED_DATE <= @formCompletionToDate) OR @formCompletionToDate IS NULL) 
           AND ((a.HEALTH_CONCERNS_RESPONSE = @healthConcerns) OR @healthConcerns = 'All') 
           AND ((a.REQUEST_SEEN_RESPONSE = @requestToBeSeen) OR @requestToBeSeen = 'All') 
	         AND ((ISNULL(@subpopulationFlag,'') = '')
	               OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop
	                         WHERE subpop.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@subpopulationFlag, ','))
	                           AND subpop.REGISTRANT_ID = a.REGISTRANT_ID))
	         AND ((ISNULL(@adminFlag,'') = '')
 	               OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag
                            WHERE adminflag.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@adminFlag, ','))
                              AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID
                              AND adminflag.CREATED BETWEEN @adminFlagFromDate AND @adminFlagToDate))  
           AND (ISNULL(@healthFactor,'') = ''
            OR EXISTS (SELECT re.REGISTRANT_ID 
                         FROM AHOBPR.REGISTRANT_EVALUATION re
                         JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf 
                           ON re.REGISTRANT_EVALUATION_ID = hf.REGISTRANT_EVALUATION_ID
		                    WHERE a.REGISTRANT_ID = re.REGISTRANT_ID
		                    AND hf.STD_HEALTH_FACTOR_ID IN (SELECT * FROM fncSplit(@healthFactor, ','))))
           AND (deploymentAll.DEPLOYMENT_COUNTRY = @deploymentAll OR ISNULL(@deploymentAll,'') = '')
            AND (ISNULL(@deploymentExposure,'') = '' 
            OR EXISTS(SELECT deploymentExposure.REGISTRANT_ID 
                        FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure 
                        JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure
                          ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID
                        JOIN AHOBPR.STD_FORM_QUESTION quest
                          ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID
                       WHERE quest.FORM_QUESTION_UNIQUE_ID = '1.2.A'
                         AND deploymentExposure.DEPLOYMENT_COUNTRY = @deploymentExposure 
                         AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID))
	         AND (stdQuestion.FORM_QUESTION_UNIQUE_ID = @questionNumber) 
           AND (ISNULL(@answer,'') = '' 
                 OR EXISTS 
                    (
                     SELECT x.STD_FORM_ANSWER_ID
                       FROM AHOBPR.STD_FORM_QUESTION w
                       JOIN AHOBPR.STD_FORM_ANSWER x 
                         ON w.STD_FORM_QUESTION_ID = x.STD_FORM_QUESTION_ID
                       JOIN AHOBPR.FORM_RESPONSE_ANSWER rAns
                         ON rAns.STD_FORM_ANSWER_ID = x.STD_FORM_ANSWER_ID
                      WHERE w.FORM_QUESTION_UNIQUE_ID = @questionNumber
                        AND EXISTS(SELECT [TEXT] 
                                     FROM AHOBPR.STD_FORM_ANSWER 
                                    WHERE STD_FORM_ANSWER_ID IN (SELECT * FROM fncSplit(@answer, ','))
                                      AND TEXT = x.TEXT )
                        AND rAns.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID)
               )				   	
	    )  results
  		GROUP BY Location, LocationID	;		


END
-- Parameters
  --@status, @dutyStatus ,@questionnaireStartDate, @questionnaireCompleteDate, 
  --@questionNumber, @answer, @healthConcerns= 'All', @requestToBeSeen = 'All',
  --@registryFlag,@InstitutionId = 0, @VisnId = '' 
-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN'   , @questionNumber = '1.2.E'  , @answer = '19' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy =  'Facility' , @questionNumber = '1.2.E'  , @answer = '19' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @InstitutionId  1000109
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy =  'VISN' , @healthFactor = '44,45,46,47'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @questionNumber = '1.2.E', @answer = '19' 
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportClinicallyRevelantSummary]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
--      Author:		Bruce Clegg
-- Create date: February 4, 2015
-- Description:	Used for the AHOBPR Clinically Revelant Summary
--        Note: Data is massaged for questions 1.2.A, 1.2.F, 1.2.G, 2.5.A and 2.5.C 
-- Modification log

-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportClinicallyRevelantSummary]
       @RegistrantId INT = 0         
AS
BEGIN

 
   --Temp table concatenate Answers for Questions
  CREATE TABLE #Answers
  (
     QuestionNumber VARCHAR(100),
     QuestionNumberDisplay VARCHAR(100),
     AnswerValues VARCHAR(8000)
  ); 


  -- Load all clinical relevent answers that are NOT from a Deployment
  WITH Responses
  AS (SELECT qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumber,
	           ISNULL(rAns.ANSWER_VALUE,ans.[TEXT])  AS AnswerValue
	      FROM AHOBPR.REGISTRANT reg
	      JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
	      JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
	      JOIN AHOBPR.FORM_RESPONSE_ANSWER rAns ON rQst.FORM_RESPONSE_QUESTION_ID = rAns.FORM_RESPONSE_QUESTION_ID
	      JOIN AHOBPR.STD_FORM_ANSWER ans ON rAns.STD_FORM_ANSWER_ID = ans.STD_FORM_ANSWER_ID
	      JOIN AHOBPR.STD_FORM_QUESTION qst ON rQst.STD_FORM_QUESTION_ID = qst.STD_FORM_QUESTION_ID
	     WHERE fr.STD_FORM_ID = ans.STD_FORM_ID
	       AND qst.STD_FORM_ID = fr.STD_FORM_ID
	       AND ans.CLINICAL_RELEVANT_FLAG = 1
	       AND reg.REGISTRANT_ID = @RegistrantId
	       AND rQst.REGISTRANT_DEPLOYMENT_ID IS NULL
  )

  INSERT INTO #Answers (QuestionNumber, QuestionNumberDisplay, AnswerValues)
   SELECT a.QuestionNumber, a.QuestionNumber,
          STUFF((SELECT '~' + b.AnswerValue 
          FROM Responses b 
         WHERE a.QuestionNumber = b.QuestionNumber 
                FOR XML PATH('')), 1, 1, '')  AnswerValues
          FROM Responses a
      GROUP BY a.QuestionNumber
      ORDER BY a.QuestionNumber;
     
  -- Load specific clinical relevent answers summarized for all Deployments - '1.2.A','1.2.F' 
  INSERT INTO #Answers (QuestionNumber, QuestionNumberDisplay, AnswerValues)
       SELECT qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumber
             ,qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumberDisplay
	           ,'Said yes to '+ CONVERT(VARCHAR(2),SUM(CASE WHEN ISNULL(rAns.ANSWER_VALUE,ans.[TEXT]) = 'Yes' THEN 1 ELSE 0 END)) 
	           + ' of ' + CONVERT(VARCHAR(2),COUNT(*)) + ' deployments' AS AnswerValues
          FROM AHOBPR.REGISTRANT reg
          JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
          JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
          LEFT JOIN AHOBPR.FORM_RESPONSE_ANSWER rAns ON rQst.FORM_RESPONSE_QUESTION_ID = rAns.FORM_RESPONSE_QUESTION_ID
          LEFT JOIN AHOBPR.STD_FORM_ANSWER ans ON rAns.STD_FORM_ANSWER_ID = ans.STD_FORM_ANSWER_ID
          JOIN AHOBPR.STD_FORM_QUESTION qst ON rQst.STD_FORM_QUESTION_ID = qst.STD_FORM_QUESTION_ID
         WHERE qst.STD_FORM_ID = fr.STD_FORM_ID
           AND reg.REGISTRANT_ID = @RegistrantId
           AND qst.FORM_QUESTION_UNIQUE_ID in ('1.2.A','1.2.F')
           GROUP BY qst.FORM_QUESTION_UNIQUE_ID; 
  
    -- Always Delete any zero counts from above that were created in order to capture true Deployment count.          
  DELETE FROM #Answers WHERE AnswerValues LIKE 'Said yes to 0 of % deployments'
                          AND QuestionNumber in ('1.2.A','1.2.F');
  
    
  -- Load specific clinical relevent answers summarized for all Deployments -- '1.2.G'
  INSERT INTO #Answers (QuestionNumber, QuestionNumberDisplay, AnswerValues)
      SELECT qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumber
           ,qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumberDisplay
	         ,'Maximum: '+ CONVERT(VARCHAR(2),MAX(CONVERT(INT,rAns.ANSWER_VALUE))) 
	         + ' hours, Average: '+ LEFT(CONVERT(VARCHAR(20),AVG(CONVERT(DECIMAL(6,2),rAns.ANSWER_VALUE))),4)
	         + ' hours, Deployments: ' + CONVERT(VARCHAR(2),COUNT(*)) AS AnswerValues
        FROM AHOBPR.REGISTRANT reg
        JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
        JOIN AHOBPR.FORM_RESPONSE_ANSWER rAns ON rQst.FORM_RESPONSE_QUESTION_ID = rAns.FORM_RESPONSE_QUESTION_ID
        JOIN AHOBPR.STD_FORM_QUESTION qst ON rQst.STD_FORM_QUESTION_ID = qst.STD_FORM_QUESTION_ID
       WHERE qst.STD_FORM_ID = fr.STD_FORM_ID
         AND qst.STD_FORM_ID = fr.STD_FORM_ID
         AND reg.REGISTRANT_ID = @RegistrantId
         AND qst.FORM_QUESTION_UNIQUE_ID = '1.2.G'
         GROUP BY qst.FORM_QUESTION_UNIQUE_ID; 
                                   
    -- Always Delete any Null or Empty Answers.          
  DELETE FROM #Answers WHERE ISNULL(AnswerValues,'')  = '';
      

  -- Tobacco Exposure
  -- if both 2.5.A and 2.5.C exist, replace with Combined answer text'  
  DECLARE @25A VARCHAR(200) = (SELECT AnswerValues FROM #Answers WHERE QuestionNumber = '2.5.A')
  DECLARE @25C VARCHAR(200) = (SELECT AnswerValues FROM #Answers WHERE QuestionNumber = '2.5.C')
  IF @25A = 'Yes'
       IF  @25C = 'Not at all'
          UPDATE #Answers SET AnswerValues = 'Past Smoker' 
                             ,QuestionNumberDisplay = '2.5'
                        WHERE QuestionNumber = '2.5.A';
       ELSE
          UPDATE #Answers SET AnswerValues = 'Current Smoker'
                             ,QuestionNumberDisplay = '2.5'
                        WHERE QuestionNumber = '2.5.A';
   IF  @25A = 'No'
       UPDATE #Answers SET AnswerValues = 'Never smoked' 
                             ,QuestionNumberDisplay = '2.5'
                        WHERE QuestionNumber = '2.5.A';

  -- Always Delete 2.5.C, as it cannot stand on it's own         
  DELETE FROM #Answers WHERE QuestionNumber = '2.5.C';     
      
  -- Final Query         
	SELECT DISTINCT 
          list.QuestionNumberDisplay AS QuestionNumber
	       ,CASE WHEN qst.SHORT_TEXT = 'Have you smoked at least 100 cigarettes in your entire life?'  -- 2.5.A
	             THEN 'Have you ever smoked?'
	             ELSE qst.SHORT_TEXT END  AS QuestionText
	       ,REPLACE(list.AnswerValues,'~','<br/>') AS AnswerValues
	       ,sec.STD_FORM_SECTION_ID AS SectionId                    
	       ,sub.STD_FORM_SUB_SECTION_ID AS SubsectionId	              
	       ,CASE WHEN ISNULL(sub.MENU_ITEM_NAME, '') = '' 
	             THEN Convert(VARCHAR, sec.BRP_FORM_SECTION_ID) + ' ' + sec.MENU_ITEM_NAME
	             ELSE Convert(VARCHAR, sec.BRP_FORM_SECTION_ID) + '.' + Convert(VARCHAR, sub.BRP_FORM_SUB_SECTION_ID) + ' ' + sec.MENU_ITEM_NAME + ' > ' + sub.MENU_ITEM_NAME
	             END AS SectionAndSubSection
	  FROM AHOBPR.REGISTRANT reg
	  JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
	  JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
	  JOIN AHOBPR.STD_FORM_QUESTION qst ON rQst.STD_FORM_QUESTION_ID = qst.STD_FORM_QUESTION_ID
	  JOIN #Answers list ON qst.FORM_QUESTION_UNIQUE_ID = list.QuestionNumber 
	  JOIN STD_FORM_SECTION sec ON sec.STD_FORM_SECTION_ID = qst.STD_FORM_SECTION_ID
	  JOIN STD_FORM_SUB_SECTION sub ON sub.STD_FORM_SUB_SECTION_ID = qst.STD_FORM_SUB_SECTION_ID
	 WHERE qst.STD_FORM_ID = fr.STD_FORM_ID
	   AND reg.REGISTRANT_ID = @RegistrantId;
	  	 
  DROP TABLE #Answers
END

-- EXEC [AHOBPR].[SP_ReportClinicallyRevelantSummary] 108
-- 5  6  7  8  108
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportRegistrantEmail]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Jan 12, 2015
-- Description:	Used for the AHOBPR Contact Report  -- exec [AHOBPR].[SP_ReportRegistrantContact]    (More options at bottom)
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportRegistrantEmail]
       @RegistrantStatus  VARCHAR(50) = '',  -- '1,2,3,4,5,6,7'
       @SvcStatus  VARCHAR(50) = '',         -- '1,2,3'
       @AdminFlagId INT = 0,                 -- 60
       @AdminFromDateText VARCHAR(50) = NULL,
       @AdminToDateText VARCHAR(50) = NULL,
       @SubPopulationFlagId INT = 0,         -- 65
       @InstitutionId INT = 0,               -- 1000109,  1000089
       @VisnId VARCHAR(50) = '',              -- 'V16', 'V01'
       @CompletedFromDateText VARCHAR(50) = NULL,
       @CompletedToDateText VARCHAR(50) = NULL
AS
BEGIN

DECLARE @AdminFromDate DATETIME2(0) = ISNULL(dbo.CleanDate(@AdminFromDateText),'19000101')
DECLARE @AdminToDate   DATETIME2(0) = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@AdminToDateText),GETDATE())); 
DECLARE @CompletedFromDate DATETIME2(0) = ISNULL(dbo.CleanDate(@CompletedFromDateText),'19000101')
DECLARE @CompletedToDate   DATETIME2(0) = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@CompletedToDateText),GETDATE())); 

WITH contacts 
AS (     
    SELECT email.REGISTRANT_ID,
           dbo.MixedCase(ISNULL(email.TYPE,'Default')) AS ContactType,
           'email' AS SubType,		     
		       ISNULL(email.EMAIL,'') AS EMAIL
      FROM AHOBPR.REGISTRANT_EMAIL email
    )
  	SELECT 
  	      reg.REGISTRANT_ID,
		      (reg.LAST_NAME + ', ' + reg.FIRST_NAME + ' ' + reg.MIDDLE_NAME) AS RegistrantName,
		      contacts.ContactType,
		      contacts.SubType,
		      contacts.EMAIL
	  FROM AHOBPR.REGISTRANT reg	
	  JOIN contacts  
		  ON reg.REGISTRANT_ID = contacts.REGISTRANT_ID	 
		LEFT JOIN dbo.viewFacilitiesByVisn inst
		  ON inst.institution_id = reg.STD_INSTITUTION_ID
 	 WHERE (reg.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@RegistrantStatus, ',')) 
	        OR ISNULL(@RegistrantStatus,'') = '')
	   AND (reg.STD_SERVICE_STATUS_ID IN (SELECT * FROM fncSplit(@SvcStatus, ',')) 
	        OR ISNULL(@SvcStatus,'') = '')	
     AND (reg.STD_INSTITUTION_ID =  @InstitutionId
          OR ISNULL(@InstitutionId,0) = 0) 
     AND (inst.VisnID =  @VisnID
          OR ISNULL(@VisnID,'') = '') 
     AND (ISNULL(@SubPopulationFlagId, 0) = 0 
          OR EXISTS(SELECT [REGISTRANT_ID] FROM AHOBPR.REGISTRANT_REGISTRY_FLAG popFlag
                     WHERE popFlag.REGISTRANT_ID = reg.REGISTRANT_ID
                       AND popFlag.STD_REGISTRY_FLAG_ID = @SubPopulationFlagId))
     AND (ISNULL(@AdminFlagId, 0) = 0 
          OR EXISTS(SELECT [REGISTRANT_ID] FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminFlag
                     WHERE adminFlag.REGISTRANT_ID = reg.REGISTRANT_ID
                       AND adminFlag.STD_REGISTRY_FLAG_ID = @AdminFlagId
                       AND adminFlag.CREATED BETWEEN @AdminFromDate AND @AdminToDate))   
     AND ((ISNULL(@CompletedFromDateText,'') = '' AND ISNULL(@CompletedToDateText,'') = '' )
         OR EXISTS(SELECT resp.REGISTRANT_ID, stat.QUESTIONNAIRE_COMPLETED_DATE
                     FROM AHOBPR.FORM_RESPONSE_STATUS stat
                     JOIN AHOBPR.FORM_RESPONSE resp
                       ON resp.FORM_RESPONSE_ID = stat.FORM_RESPONSE_ID
                    WHERE resp.REGISTRANT_ID = reg.REGISTRANT_ID
                      AND stat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @CompletedFromDate AND @CompletedToDate))                 
    ORDER BY reg.REGISTRANT_ID, RegistrantName, SubType, ContactType;
                                                                                                             
END

-- exec [AHOBPR].[SP_ReportRegistrantEmail] NULL, NULL, 0, NULL, NULL, 0, 0, NULL, ''
-- exec [AHOBPR].[SP_ReportRegistrantEmail] '5,6,7', NULL, 0, NULL, NULL, 0, 0, NULL
-- exec [AHOBPR].[SP_ReportRegistrantEmail] NULL, '2', 0, NULL, NULL, 0, 0, NULL
-- exec [AHOBPR].[SP_ReportRegistrantEmail] NULL, NULL, 60, NULL, '20141204', 0, 0, NULL
-- exec [AHOBPR].[SP_ReportRegistrantEmail] NULL, NULL, 60, '12/04/2014', NULL, 0, 0, NULL
-- exec [AHOBPR].[SP_ReportRegistrantEmail] NULL, NULL, 60, '12/03/2014', '12/12/2014', 0, 0, NULL
-- exec [AHOBPR].[SP_ReportRegistrantEmail] NULL, NULL, 0, NULL, NULL, 65, 0, NULL
-- exec [AHOBPR].[SP_ReportRegistrantEmail] NULL, NULL, 0, NULL, NULL, 0, 1000109, NULL
-- exec [AHOBPR].[SP_ReportRegistrantEmail] NULL, NULL, 0, NULL, NULL, 0, 0, 'V01'
-- exec [AHOBPR].[SP_ReportRegistrantEmail] @CompletedFromDateText = '08/13/2014'
-- exec [AHOBPR].[SP_ReportRegistrantEmail]  @CompletedToDateText = '08/13/2014'
-- exec [AHOBPR].[SP_ReportRegistrantEmail] @CompletedFromDateText = '08/13/2014', @CompletedToDateText = '08/13/2014'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportRegistrantPhone]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Jan 12, 2015
-- Description:	Used for the AHOBPR Contact Report  -- exec [AHOBPR].[SP_ReportRegistrantContact]    (More options at bottom)
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportRegistrantPhone]
       @RegistrantStatus  VARCHAR(50) = '',  -- '1,2,3,4,5,6,7'
       @SvcStatus  VARCHAR(50) = '',         -- '1,2,3'
       @AdminFlagId INT = 0,                 -- 60
       @AdminFromDateText VARCHAR(50) = NULL,
       @AdminToDateText VARCHAR(50) = NULL,
       @SubPopulationFlagId INT = 0,         -- 65
       @InstitutionId INT = 0,               -- 1000109,  1000089
       @VisnId VARCHAR(50) = '',              -- 'V16', 'V01'
       @CompletedFromDateText VARCHAR(50) = NULL,
       @CompletedToDateText VARCHAR(50) = NULL
AS
BEGIN

DECLARE @AdminFromDate DATETIME2(0) = ISNULL(dbo.CleanDate(@AdminFromDateText),'19000101')
DECLARE @AdminToDate   DATETIME2(0) = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@AdminToDateText),GETDATE())); 
DECLARE @CompletedFromDate DATETIME2(0) = ISNULL(dbo.CleanDate(@CompletedFromDateText),'19000101')
DECLARE @CompletedToDate   DATETIME2(0) = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@CompletedToDateText),GETDATE())); 

WITH contacts 
AS (     
    SELECT phone.REGISTRANT_ID,
           dbo.MixedCase(ISNULL(phone.TYPE,'Default')) AS ContactType,
           'phone' AS SubType,		     
		       ISNULL(phone.PHONE_NUMBER,'') AS PHONE_NUMBER
      FROM AHOBPR.REGISTRANT_PHONE	phone      
    )   
  	SELECT 
  	      reg.REGISTRANT_ID,
		      (reg.LAST_NAME + ', ' + reg.FIRST_NAME + ' ' + reg.MIDDLE_NAME) AS RegistrantName,
		      contacts.ContactType,
		      contacts.SubType,
		      contacts.PHONE_NUMBER
	  FROM AHOBPR.REGISTRANT reg	
	  JOIN contacts  
		  ON reg.REGISTRANT_ID = contacts.REGISTRANT_ID	 
		LEFT JOIN dbo.viewFacilitiesByVisn inst
		  ON inst.institution_id = reg.STD_INSTITUTION_ID
 	 WHERE (reg.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@RegistrantStatus, ',')) 
	        OR ISNULL(@RegistrantStatus,'') = '')
	   AND (reg.STD_SERVICE_STATUS_ID IN (SELECT * FROM fncSplit(@SvcStatus, ',')) 
	        OR ISNULL(@SvcStatus,'') = '')	
     AND (reg.STD_INSTITUTION_ID =  @InstitutionId
          OR ISNULL(@InstitutionId,0) = 0) 
     AND (inst.VisnID =  @VisnID
          OR ISNULL(@VisnID,'') = '') 
     AND (ISNULL(@SubPopulationFlagId, 0) = 0 
          OR EXISTS(SELECT [REGISTRANT_ID] FROM AHOBPR.REGISTRANT_REGISTRY_FLAG popFlag
                     WHERE popFlag.REGISTRANT_ID = reg.REGISTRANT_ID
                       AND popFlag.STD_REGISTRY_FLAG_ID = @SubPopulationFlagId))
     AND (ISNULL(@AdminFlagId, 0) = 0 
          OR EXISTS(SELECT [REGISTRANT_ID] FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminFlag
                     WHERE adminFlag.REGISTRANT_ID = reg.REGISTRANT_ID
                       AND adminFlag.STD_REGISTRY_FLAG_ID = @AdminFlagId
                       AND adminFlag.CREATED BETWEEN @AdminFromDate AND @AdminToDate))   
     AND ((ISNULL(@CompletedFromDateText,'') = '' AND ISNULL(@CompletedToDateText,'') = '' )
         OR EXISTS(SELECT resp.REGISTRANT_ID, stat.QUESTIONNAIRE_COMPLETED_DATE
                     FROM AHOBPR.FORM_RESPONSE_STATUS stat
                     JOIN AHOBPR.FORM_RESPONSE resp
                       ON resp.FORM_RESPONSE_ID = stat.FORM_RESPONSE_ID
                    WHERE resp.REGISTRANT_ID = reg.REGISTRANT_ID
                      AND stat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @CompletedFromDate AND @CompletedToDate))                 
    ORDER BY reg.REGISTRANT_ID, RegistrantName, SubType, ContactType;
                                                                                                             
END

-- exec [AHOBPR].[SP_ReportRegistrantPhone] NULL, NULL, 0, NULL, NULL, 0, 0, NULL, ''
-- exec [AHOBPR].[SP_ReportRegistrantPhone] '5,6,7', NULL, 0, NULL, NULL, 0, 0, NULL
-- exec [AHOBPR].[SP_ReportRegistrantPhone] NULL, '2', 0, NULL, NULL, 0, 0, NULL
-- exec [AHOBPR].[SP_ReportRegistrantPhone] NULL, NULL, 60, NULL, '20141204', 0, 0, NULL
-- exec [AHOBPR].[SP_ReportRegistrantPhone] NULL, NULL, 60, '12/04/2014', NULL, 0, 0, NULL
-- exec [AHOBPR].[SP_ReportRegistrantPhone] NULL, NULL, 60, '12/03/2014', '12/12/2014', 0, 0, NULL
-- exec [AHOBPR].[SP_ReportRegistrantPhone] NULL, NULL, 0, NULL, NULL, 65, 0, NULL
-- exec [AHOBPR].[SP_ReportRegistrantPhone] NULL, NULL, 0, NULL, NULL, 0, 1000109, NULL
-- exec [AHOBPR].[SP_ReportRegistrantPhone] NULL, NULL, 0, NULL, NULL, 0, 0, 'V01'
-- exec [AHOBPR].[SP_ReportRegistrantPhone] @CompletedFromDateText = '08/13/2014'
-- exec [AHOBPR].[SP_ReportRegistrantPhone]  @CompletedToDateText = '08/13/2014'
-- exec [AHOBPR].[SP_ReportRegistrantPhone] @CompletedFromDateText = '08/13/2014', @CompletedToDateText = '08/13/2014'
GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Creating [AHOBPR].[SP_ReportRegistrantAddress]...';


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER OFF;


GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Jan 12, 2015
-- Description:	Used for the AHOBPR Contact Report  -- exec [AHOBPR].[SP_ReportRegistrantContact]    (More options at bottom)
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportRegistrantAddress]
       @RegistrantStatus  VARCHAR(50) = '',  -- '1,2,3,4,5,6,7'
       @SvcStatus  VARCHAR(50) = '',         -- '1,2,3'
       @AdminFlagId INT = 0,                 -- 60
       @AdminFromDateText VARCHAR(50) = NULL,
       @AdminToDateText VARCHAR(50) = NULL,
       @SubPopulationFlagId INT = 0,         -- 65
       @InstitutionId INT = 0,               -- 1000109,  1000089
       @VisnId VARCHAR(50) = '',              -- 'V16', 'V01'
       @CompletedFromDateText VARCHAR(50) = NULL,
       @CompletedToDateText VARCHAR(50) = NULL
AS
BEGIN

DECLARE @AdminFromDate DATETIME2(0) = ISNULL(dbo.CleanDate(@AdminFromDateText),'19000101')
DECLARE @AdminToDate   DATETIME2(0) = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@AdminToDateText),GETDATE())); 
DECLARE @CompletedFromDate DATETIME2(0) = ISNULL(dbo.CleanDate(@CompletedFromDateText),'19000101')
DECLARE @CompletedToDate   DATETIME2(0) = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@CompletedToDateText),GETDATE())); 

WITH contacts 
AS (     
    SELECT addr.REGISTRANT_ID,
           dbo.MixedCase(ISNULL(addr.TYPE,'Default'))  AS ContactType,
           'address' AS SubType,
		       ISNULL(addr.STREET1,'')  AS STREET1, 
		       ISNULL(addr.STREET2,'')  AS STREET2,
		       ISNULL(addr.CITY,'')     AS CITY,
		       ISNULL(addr.[STATE],'')  AS [STATE],
		       ISNULL(addr.COUNTRY,'')  AS COUNTRY,
		       ISNULL(addr.ZIP,'')      AS ZIP
		  FROM  AHOBPR.[REGISTRANT_ADDRESS] addr 
    )   
  	SELECT 
  	      reg.REGISTRANT_ID,
		      (reg.LAST_NAME + ', ' + reg.FIRST_NAME + ' ' + reg.MIDDLE_NAME) AS RegistrantName,
		      contacts.ContactType,
		      contacts.SubType,
		      STREET1, 
		      STREET2,
		      CITY,
		      [STATE],
		      COUNTRY,
		      ZIP
	  FROM AHOBPR.REGISTRANT reg	
	  JOIN contacts  
		  ON reg.REGISTRANT_ID = contacts.REGISTRANT_ID	 
		LEFT JOIN dbo.viewFacilitiesByVisn inst
		  ON inst.institution_id = reg.STD_INSTITUTION_ID
 	 WHERE (reg.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@RegistrantStatus, ',')) 
	        OR ISNULL(@RegistrantStatus,'') = '')
	   AND (reg.STD_SERVICE_STATUS_ID IN (SELECT * FROM fncSplit(@SvcStatus, ',')) 
	        OR ISNULL(@SvcStatus,'') = '')	
     AND (reg.STD_INSTITUTION_ID =  @InstitutionId
          OR ISNULL(@InstitutionId,0) = 0) 
     AND (inst.VisnID =  @VisnID
          OR ISNULL(@VisnID,'') = '') 
     AND (ISNULL(@SubPopulationFlagId, 0) = 0 
          OR EXISTS(SELECT [REGISTRANT_ID] FROM AHOBPR.REGISTRANT_REGISTRY_FLAG popFlag
                     WHERE popFlag.REGISTRANT_ID = reg.REGISTRANT_ID
                       AND popFlag.STD_REGISTRY_FLAG_ID = @SubPopulationFlagId))
     AND (ISNULL(@AdminFlagId, 0) = 0 
          OR EXISTS(SELECT [REGISTRANT_ID] FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminFlag
                     WHERE adminFlag.REGISTRANT_ID = reg.REGISTRANT_ID
                       AND adminFlag.STD_REGISTRY_FLAG_ID = @AdminFlagId
                       AND adminFlag.CREATED BETWEEN @AdminFromDate AND @AdminToDate))   
     AND ((ISNULL(@CompletedFromDateText,'') = '' AND ISNULL(@CompletedToDateText,'') = '' )
         OR EXISTS(SELECT resp.REGISTRANT_ID, stat.QUESTIONNAIRE_COMPLETED_DATE
                     FROM AHOBPR.FORM_RESPONSE_STATUS stat
                     JOIN AHOBPR.FORM_RESPONSE resp
                       ON resp.FORM_RESPONSE_ID = stat.FORM_RESPONSE_ID
                    WHERE resp.REGISTRANT_ID = reg.REGISTRANT_ID
                      AND stat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN @CompletedFromDate AND @CompletedToDate))                 
    ORDER BY reg.REGISTRANT_ID, RegistrantName, SubType, ContactType;
                                                                                                             
END

-- exec [AHOBPR].[SP_ReportRegistrantAddress] NULL, NULL, 0, NULL, NULL, 0, 0, NULL, ''
 --exec [AHOBPR].[SP_ReportRegistrantAddress] '5,6,7', NULL, 0, NULL, NULL, 0, 0, NULL
 --exec [AHOBPR].[SP_ReportRegistrantAddress] NULL, '2', 0, NULL, NULL, 0, 0, NULL
 --exec [AHOBPR].[SP_ReportRegistrantAddress] NULL, NULL, 60, NULL, '20141204', 0, 0, NULL
 --exec [AHOBPR].[SP_ReportRegistrantAddress] NULL, NULL, 60, '12/04/2014', NULL, 0, 0, NULL
 --exec [AHOBPR].[SP_ReportRegistrantAddress] NULL, NULL, 60, '12/03/2014', '12/12/2014', 0, 0, NULL
 --exec [AHOBPR].[SP_ReportRegistrantAddress] NULL, NULL, 0, NULL, NULL, 65, 0, NULL
 --exec [AHOBPR].[SP_ReportRegistrantAddress] NULL, NULL, 0, NULL, NULL, 0, 1000109, NULL
 --exec [AHOBPR].[SP_ReportRegistrantAddress] NULL, NULL, 0, NULL, NULL, 0, 0, 'V01'
 --exec [AHOBPR].[SP_ReportRegistrantAddress] @CompletedFromDateText = '08/13/2014'
 --exec [AHOBPR].[SP_ReportRegistrantAddress] @CompletedToDateText = '08/13/2014'
 --exec [AHOBPR].[SP_ReportRegistrantAddress] @CompletedFromDateText = '08/13/2014', @CompletedToDateText = '08/13/2014'

GO

PRINT 'Write to DatabaseChangeLog...';
GO

INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('$(MajorReleaseNumber)'
           ,'$(MinorReleaseNumber)'
           ,'$(PointReleaseNumber)'
           ,0
           ,'Step 2 - Registry.Database.Deploy.sql'
		       ,'AHOBPR 1.0.24 Deployment'
           ,'AHOBPR'
           ,GETDATE());
GO


PRINT '';
PRINT 'Step 2 - Registry.Database.Deploy.sql Script Complete.';
PRINT '';
PRINT 'Completed ' + CAST(GETDATE() AS varchar(20)) + '.';
